/**
 * 校验枚举工具
 * 
 */

import { ERRORENUM } from "../config/errorEnum";
import { BizError } from "./bizError";


/**
 * 校验value是否符合传入的枚举
 * @param enumConf 目标枚举
 * @param value 目标值
 * 无返回 有异常直接报错
 */
export function eccEnumValue(name:string, key:string, enumConf, value:any) {
    let eccSuccess = true;
    if ( typeof value == 'number' ) {
        if (!enumConf[value] ) eccSuccess = false;
    } else if (Array.isArray(value)) {
        value.forEach(item => {
            if ( !enumConf[item] ) eccSuccess = false;
        });
    }
    
    if (!eccSuccess) throw new BizError(ERRORENUM.表单校验失败, `${name} 下的 ${key} 字段值为 ${value} 不满足枚举范围`);
}


/**
 * 将枚举值转换成对应的枚举名(key)
 * @param enumConf 目标枚举
 * @param value 目标值
 * @returns string  返回字符串 如果传入多个枚举值，就拼接字符串
 */
export function changeEnumValue(enumConf, value:any) {
    if (!value) return '';
    if ( typeof value == 'number' || typeof value == 'string' ) {
        let str = enumConf[value];
        /**特化处理 */
        if(/_dou/.test(str)) str = str.replace(/_dou/gm, "，");
        if(/_zyh/.test(str)) str = str.replace(/_zyh/gm, "“");
        if(/_yyh/.test(str)) str = str.replace(/_yyh/gm, "”");
        if(/_dun/.test(str)) str = str.replace(/_dun/gm, "、");
        if(/_ju/.test(str)) str = str.replace(/_ju/gm, "。");

        return str
    }
    let str = "";
    value.forEach((item, index) => {
        let subStr = enumConf[item];
        /**特化处理 */
        if(/_dou/.test(subStr)) subStr = subStr.replace(/_dou/, "，");
        if(/_zyh/.test(subStr)) subStr = subStr.replace(/_zyh/, "“");
        if(/_yyh/.test(subStr)) subStr = subStr.replace(/_yyh/, "”");
        if(/_dun/.test(subStr)) subStr = subStr.replace(/_dun/, "、");
        if(/_ju/.test(subStr)) subStr = subStr.replace(/_ju/, "。");
        
        str += subStr;
        if (index == value.length-1) str+="";
        else str += ","
    });

    return str;
}

