/**
 * 零碎的通用工具
 */

import moment = require("moment");

/**
 * 匹配新旧对象变化
 * 将newObj 与 oldObj 比对，将newObj中发生变化的key返回
 * 使用前需要校验对象中的内容
 * @param newObj 新对象
 * @param oldObj 旧对象
 * @returns [key] 发生变化的key
 */
export function checkChange(newObj, oldObj) {
    let changeKeyList = [];
    for (let newKey in newObj) {
        if (`${newObj[newKey]}` != `${oldObj[newKey]}`) changeKeyList.push(newKey);
    }
    return changeKeyList;
}

/**
 * 根据conf截取data中的数据
 * @param conf 
 * @param data 
 * @param isAdmin 是否是管理后台
 * @returns 
 */
export function extractData(conf, data, timeFormat?) {
    let result = {};
    for (let key in conf) {
        let confInfo = conf[key];
        if (confInfo.changeDate) {
            if (timeFormat) result[key] = data[key] ? moment(data[key]).format(timeFormat) : '-';
            else result[key] = data[key] || 0;
        }else {
            result[key] = data[key];
            if (typeof result[key] == 'string' && !result[key]) result[key] = '';
        }
    }
    return result;
}
