import { OPERATIONALDATATYPE, TABLENAME } from "../config/dbEnum";
import { operationalData, selectData } from "../middleware/databaseSuccess";
import * as enums from "../config/enum";
import { getPwdMd5, md5PwdStr } from "./system";
import moment = require("moment");

const xlsx = require('node-xlsx');
const path = require('path');
const md5 = require("md5");


const PartyPositionsChangeConfig = {
    "党总支书记": enums.PARTYPOSITIONS.党总支书记,
    "党总支副书记": enums.PARTYPOSITIONS.党总支副书记,
    "党总支宣传委员": enums.PARTYPOSITIONS.党总支宣传委员,
    "党总支统战委员": enums.PARTYPOSITIONS.党总支统战委员,
    "党总支纪检委员": enums.PARTYPOSITIONS.党总支纪检委员,
    "支部书记": enums.PARTYPOSITIONS.支部书记,
    "支部副书记": enums.PARTYPOSITIONS.支部副书记,
    "纪检委员": enums.PARTYPOSITIONS.纪检委员,
    "统战委员": enums.PARTYPOSITIONS.统战委员,
    "组织委员": enums.PARTYPOSITIONS.组织委员,
    "宣传委员": enums.PARTYPOSITIONS.宣传委员,
}

const BranchNameChangeConfig = {
    "牙防所第一支部": enums.BRANCHNAME.牙防所第一支部,
    "牙防所第二支部": enums.BRANCHNAME.牙防所第二支部,
    "牙防所第三支部": enums.BRANCHNAME.牙防所第三支部,
    "牙防所第四支部": enums.BRANCHNAME.牙防所第四支部,
}

const DepartmentConfig = {
    "办公室": enums.DEDPARTMENT.办公室,
    "财务科": enums.DEDPARTMENT.财务科,
    "放射科": enums.DEDPARTMENT.放射科,
    "工会": enums.DEDPARTMENT.工会,
    "技术室": enums.DEDPARTMENT.技术室,
    "颌面外科": enums.DEDPARTMENT.颌面外科,
    "护理": enums.DEDPARTMENT.护理,
    "护理部": enums.DEDPARTMENT.护理部,
    "检验科": enums.DEDPARTMENT.检验科,
    "康健分所": enums.DEDPARTMENT.康健分所,
    "科教科": enums.DEDPARTMENT.科教科,
    "口腔颌面外科": enums.DEDPARTMENT.口腔颌面外科,
    "口腔科": enums.DEDPARTMENT.口腔科,
    "口腔修复科": enums.DEDPARTMENT.口腔修复科,
    "口腔正畸科": enums.DEDPARTMENT.口腔正畸科,
    "口腔综合科": enums.DEDPARTMENT.口腔综合科,
    "人事科": enums.DEDPARTMENT.人事科,
    "特需": enums.DEDPARTMENT.特需,
    "信息科": enums.DEDPARTMENT.信息科,
    "修复科": enums.DEDPARTMENT.修复科,
    "牙体牙髓科": enums.DEDPARTMENT.牙体牙髓科,
    "牙周科": enums.DEDPARTMENT.牙周科,
    "药房": enums.DEDPARTMENT.药房,
    "医务科": enums.DEDPARTMENT.医务科,
    "预防科": enums.DEDPARTMENT.预防科,
    "预防口腔": enums.DEDPARTMENT.预防口腔,
    "儿童口腔科": enums.DEDPARTMENT.儿童口腔科,
    "院部": enums.DEDPARTMENT.院部,
    "种植科": enums.DEDPARTMENT.种植科,
    "正畸科": enums.DEDPARTMENT.正畸科,
    "综合科": enums.DEDPARTMENT.综合科,
}

export async function initBasicData() {
    await initPartyMember();
    await initLearningPower();
    await initPartyExpenses();
    await ininThirdLevel();
    // await initOrganizationalLife();
    // await initPartyVanguard();
    // await initBranchSystem();
    // await initInforMation();
}


/**
 * 党员基础信息初始化
 */
async function initPartyMember() {
    let count = await selectData(OPERATIONALDATATYPE.查询数据量, TABLENAME.党员基础信息表, {}, []); //党员总数
    if (count > 5) {
        console.log("***** 党员基础信息数据 无需初始化 *****");
        return;
    }

    let {sheetMap} = getExcel(path.join(__dirname.substring(0, __dirname.indexOf("out")), "res", "牙防所基础数据收集.xlsx"));

    let dataList = sheetMap["党员信息"];
    let titleMap = {
        "0": "name", //姓名
        "1": "sex", //性别
        "2": "birthDate", //出生时间
        "3": "phone", //手机号码
        "4": "levelOfEducation", //文化程度
        "5": "partyJoiningTime", //入党时间
        "6": "administrativePositionName", //行政职务
        "7": "remarks", //备注
        "8": "etId", //名册录入类型
        "9": "partyPositionsName", //党内职务
        "10": "listedAsActivistsTime", //列为积极份子时间（入党积极份子填写）
        "11": "askForTime", //申请入党时间（入党申请填写）
        "12": "talkTime", //谈话时间（入党申请填写）
        "13": "bId", //支部名称
        "14": "departmentName", //所属科室
        "15": "partyState", //党员状态
    }

    let utc = new Date();
    let addList = [];
    dataList.forEach( (subList, index) => {
        if (!index) return; //跳过表头
        let addDataInfo:any = {
            pmId: null,
            etId: null,
            name: null, 
            sex: null,
            birthDate: null,
            phone: null,
            levelOfEducation: null,
            bId: null,
            partyJoiningTime: null,
            administrativePositionName: null,
            partyPositionsName: null,
            departmentName: null,
            askForTime: null,
            listedAsActivistsTime: null,
            liaison: null,
            talkTime: null,
            partyState: null,
            isAdmin: false,
            loginId: null,
            pwd: null,
        }

        for (let i = 0; i <= 15; i++) {
            let item = subList[i];
            let key = titleMap[i];
            let value = item;
            if (i == 1) {
                value = enums.SEX[item] || 0;
            }
            if (i == 2 && item) {
                value = moment(item).format("YYYY-MM-DD");
            }
            if (i ==3 ) {
                let itemStr = `${item}`;
                if(!addDataInfo.pmId) addDataInfo.pmId = md5PwdStr(itemStr.slice(itemStr.length-6));
                if(!addDataInfo.pwd) addDataInfo.pwd = md5PwdStr(itemStr.slice(itemStr.length-6));
                else addDataInfo.pwd = md5PwdStr(addDataInfo.pwd);
                addDataInfo.loginId = itemStr;
            }
            if (i == 4) {
                value = enums.DEGREE[item] || 1;
            }
            if (i == 5 && item) {
                value = moment(item).format("YYYY-MM-DD");
            }
            if (i == 6) {
                value = enums.ADMINISTRATIVEPOSITION[item] || 0;
            }
            if (i == 8) {
                value = enums.ENTRYTYPE[item] || 1;
            }
            if (i == 9) {
                value = [];
                if (item) {
                    let oldList = item.split(',');
                    oldList.forEach(oldStr => {
                        let valueNum = PartyPositionsChangeConfig[oldStr.trim()];
                        if (valueNum) value.push(valueNum);
                    });
                };
                value = JSON.stringify(value);
            }
            if (i == 10 && item) {
                value = moment(item).format("YYYY-MM-DD");
            }
            if (i == 11 && item) {
                value = moment(item).format("YYYY-MM-DD");
            }
            if (i == 12 && item) {
                value = moment(item).format("YYYY-MM-DD");
            }
            if (i == 13) {
                value = enums.BRANCHNAME[item] || 1;
            }
            if (i == 14) {
                value = [];
                if (item) {
                    let oldList = item.split(',');
                    oldList.forEach(oldStr => {
                        let valueNum = DepartmentConfig[oldStr.trim()];
                        if (valueNum) value.push(valueNum);
                    });
                };
                value = JSON.stringify(value);
            }
            if (i == 15) {
                value = enums.PARTYSTATE[item] || 0;
            }
            addDataInfo[key] = value;
        }
        addList.push(addDataInfo);
    })
    
    // await createPartyMember(addList);
    let rows = await operationalData(OPERATIONALDATATYPE.增加, TABLENAME.党员基础信息表, addList, {}); //党员总数
    console.log(rows);
    console.log("---> 党员基础信息 初始化成功");
}


/**
 * 学习强国初始化
 */
async function initLearningPower() {
    // let count = await groupFindPartyVanguardCount({});
    let count = await selectData(OPERATIONALDATATYPE.查询数据量, TABLENAME.学习强国, {}, []); //党员总数
    if (count >= 1) {
        console.log("***** 学习强国数据 无需初始化 *****");
        return;
    }

    let {sheetMap} = getExcel(path.join(__dirname.substring(0, __dirname.indexOf("out")), "res", "学习强国时长排名.xlsx"));
    let id = 1;
    for (let sheepKey in sheetMap) {
        let dataList = sheetMap[sheepKey];
        let titleMap = {
            "0": "partyMemberName", //姓名
            "1": "bId", //支部
            "2": "dayIntegral", //当日积分
            "3": "totalIntegral", //总积分
        };

        let addList = [];
        for(let index = 1; index < dataList.length; index++) {
            let subList = dataList[index];
            let addDataInfo:any = {
                lpId: id,
                pmId: null,
                bId: null,
                dayIntegral: null,
                totalIntegral: null,
                dataYear: null,
                dataMonth: null,
                dataDay: null,
                dataTime: null
            }

            for (let i = 0; i <= 3; i++) {
                let item = subList[i];
                let key = titleMap[i];
                let value = item;
                if (i == 0) {
                    // console.log(item);
                    let partyMemberDate = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.党员基础信息表, {name:item}, ["pmId"]); //党员总数
                    if (!partyMemberDate) continue;
                    addDataInfo["pmId"] = partyMemberDate.pmId;
                    value = item;
                }
                if (i == 1) {
                    value = enums.BRANCHNAME[item] || 1;
                }
                if (value || value == 0) addDataInfo[key] = value;
            }
            addDataInfo["dataYear"] = 2023;
            addDataInfo["dataMonth"] = moment("2023." + sheepKey).month() + 1;
            addDataInfo["dataDay"] = moment("2023." + sheepKey).date();
            addDataInfo["dataTime"] = moment("2023." + sheepKey).format("YYYY-MM-DD HH:mm:ss");
            if (addDataInfo.pmId) addList.push(addDataInfo);
            id++;
        }
        
        let rows = await operationalData(OPERATIONALDATATYPE.增加, TABLENAME.学习强国, addList, {});
        console.log(rows);
        console.log(sheepKey + "---> 学习强国信息 初始化成功");
    }


}


/**
 * 组织生活初始化
 */
async function initOrganizationalLife() {
    // let count = await groupFindActivityCount({});
    let count = await selectData(OPERATIONALDATATYPE.查询数据量, TABLENAME.组织生活表, {}, []);
    if (count >= 1) {
        console.log("***** 组织生活数据 无需初始化 *****");
        return;
    }
    
    let {sheetMap} = getExcel(path.join(__dirname.substring(0, __dirname.indexOf("out")), "res", "牙防所基础数据收集.xlsx"));
    let dataList = sheetMap["组织生活"];

    let titleMap = {
        "0": "themeType", //活动类型
        "1": "dataMonth", //活动时间
        "2": "theme", //活动主题
        "3": "bId", //支部名称
        "4": "fileName", //活动文件
        "5": "fileType", //文件类型
    };

    let addList = [];
    dataList.forEach( (subList, index) => {
        if (!index) return; //跳过表头
        let addDataInfo:any = {
            oId: index,
            theme: null,
            themeType: null,
            dataMonth: null,
            bId: null,
            fileName: null,
            fileType: null,
            uploadTime: moment(new Date()).format("YYYY-MM-DD HH:mm:ss")
        }

        for (let i = 0; i <= 5; i++) {
            let item =subList[i];
            let key = titleMap[i];
            let value = item;
            if (i == 0 && item) {
                value = enums.THEMETYPE[item] || 1;
            }
            if (i == 1 && item) {
                value = moment(item).format("YYYY-MM-DD HH:mm:ss");
            }
            if (i == 3 && item) {
                value = [];
                if (item) {
                    let oldList = item.split(',');
                    oldList.forEach(oldStr => {
                        let valueNum = BranchNameChangeConfig[oldStr.trim()];
                        if (valueNum) value.push(valueNum);
                    });
                };
            }
            if (i == 5) {
                value = enums.FILETYPE[item] || 1;
            }
            if (value) addDataInfo[key] = value;
        }
        addList.push(addDataInfo);
    })
    
    // await createActivity(addList);
    let rows = await operationalData(OPERATIONALDATATYPE.增加, TABLENAME.组织生活表, addList, {});
    console.log(rows);
    console.log("---> 组织生活信息 初始化成功");
}


/**
 * 支部制度初始化
 */
async function initBranchSystem() {
    // let count = await groupFindBranchSystemCount({});
    let count = await selectData(OPERATIONALDATATYPE.查询数据量, TABLENAME.支部制度表, {}, []);
    if (count >= 1) {
        console.log("***** 支部制度数据 无需初始化 *****");
        return;
    }

    let {sheetMap} = getExcel(path.join(__dirname.substring(0, __dirname.indexOf("out")), "res", "牙防所基础数据收集.xlsx"));
    let dataList = sheetMap["支部制度"];             

    let titleMap = {
        "0": "systemTitle", //制度标题
        "1": "periodOfValidity", //制度有效期
        "2": "releaseTime", //发布时间
        "3": "systemContent", //制度内容
        "4": "branchName", //支部名称
    };

    let addList = [];
    dataList.forEach( (subList, index) => {
        if (!index) return; //跳过表头
            let addDataInfo:any = {
                bsId: index,
                systemTile: null,
                bId: null,
                releaseTime: null,
                isNse: null,
                fileName: null,
                fileType: null,
                uploadTime: null
        }

        for (let i = 0; i <= 4; i++) {
            let item =subList[i];
            let key = titleMap[i];
            let value = item;
            if (i == 1 && item) {
                value = new Date(item).valueOf();
            }
            if (i == 2 && item) {
                value = new Date(item).valueOf();
            }
            if (i == 4) {
                value = [];
                if (item) {
                    let oldList = item.split(',');
                    oldList.forEach(oldStr => {
                        let valueNum = BranchNameChangeConfig[oldStr.trim()];
                        if (valueNum) value.push(valueNum);
                    });
                };
            }

            if (value) addDataInfo[key] = value;
        }
        addList.push(addDataInfo);
    })
    
    // await createBranchSystem(addList);
    let rows = await operationalData(OPERATIONALDATATYPE.增加, TABLENAME.支部制度表, addList, {});
    console.log(rows);
    console.log("---> 支部制度信息 初始化成功");
}


/**
 * 党费初始化
 */
 async function initPartyExpenses() {
    return
    // let count = await groupFindBranchSystemCount({});
    let count = await selectData(OPERATIONALDATATYPE.查询数据量, TABLENAME.党费管理表, {}, []);
    if (count >= 1) {
        console.log("***** 党费管理数据 无需初始化 *****");
        return;
    }

    let partyMenberDataList = await selectData(OPERATIONALDATATYPE.查询多个 , TABLENAME.党员基础信息表, {etId:1}, null);

    let addList = [];
    partyMenberDataList.forEach(info => {
        let {pmId, bId} = info;

        addList.push({
            pmId,
            bId,
            payType: 2,
            payTime: null,
            payableMonth: "2023-10-01 00:00:00",
            payAmount: null,
        });
    });

    // await createBranchSystem(addList);
    let rows = await operationalData(OPERATIONALDATATYPE.增加, TABLENAME.党费管理表, addList, {});
    console.log(rows);
    console.log("---> 党费信息 初始化成功");
}


/**
 * 党建质量 三级指标初始化
 */
async function ininThirdLevel() {
    let count = await selectData(OPERATIONALDATATYPE.查询数据量, TABLENAME.党建质量三级指标, {}, []);
    if (count >= 1) {
        console.log("***** 三级指标数据 无需初始化 *****");
        return;
    }

    let {sheetMap} = getExcel(path.join(__dirname.substring(0, __dirname.indexOf("out")), "res", "三级指标初始化表.xlsx"));
    let dataList = sheetMap["三级指标"];             

    let titleMap = {
        "0": "bId",
        "1": "primaryIndicators",
        "2": "secondaryIndicators",
        "3": "thirdLevelContent",
        "4": "thirdLevelScore",
        "5": "currentScore",
        "6": "completionProgress",
        "7": "weight",
        "8": "dataYear",
        "9": "lock",
    };

    let addList = [];
    dataList.forEach( (subList, index) => {
        if (!index) return; //跳过表头
            let addDataInfo:any = {
                bId: null,
                primaryIndicators: null,
                secondaryIndicators: null,
                thirdLevelContent: null,
                thirdLevelScore: null,
                currentScore: 0,
                completionProgress: 0,
                weight: null,
                dataYear: null,
                lock: 0
        }

        for (let i = 0; i <= 9; i++) {
            let item =subList[i];
            let key = titleMap[i];
            let value = item;

            if (value) addDataInfo[key] = value;
        }
        addList.push(addDataInfo);
    })
    
    // await createBranchSystem(addList);
    let rows = await operationalData(OPERATIONALDATATYPE.增加, TABLENAME.党建质量三级指标, addList, {});
    console.log(rows);
    console.log("---> 三级指标信息 初始化成功");
}





// /**
//  * 党建资讯
//  */
// async function initInforMation() {
//     let count = await groupFindpartyInformationCount({});
//     if (count >= 1) {
//         console.log("***** 党建资讯数据 无需初始化 *****");
//         return;
//     }

//     let {sheetMap} = getExcel(path.join(__dirname.substring(0, __dirname.indexOf("out")), "res", "牙防所基础数据收集.xlsx"));
//     let dataList = sheetMap["党建资讯"];

//     let titleMap = {
//         "0": "informationType", //党建资讯类型
//         "1": "title", //资讯列表
//         "2": "informationTime", //资讯时间
//         "3": "detailedInformation", //资讯详细
//         "4": "img", //图片
//         "5": "branchName", //支部名称
//     };

//     let addList = [];
//     dataList.forEach( (subList, index) => {
//         if (!index) return; //跳过表头
//         let addDataInfo:any = {
//             firstLoginIsChangePwd:false,
//         }

//         for (let i = 0; i <= 5; i++) {
//             let item =subList[i];
//             let key = titleMap[i];
//             let value = item;
//             if (i == 0) {
//                 value = enums.INFORMATION[item] || 0;
//             }
//             if (i == 2 && item) {
//                 value = new Date(item).valueOf();
//             }
//             if (i == 5) {
//                 value = [];
//                 if (item) {
//                     let oldList = item.split(',');
//                     oldList.forEach(oldStr => {
//                         let valueNum = BranchNameChangeConfig[oldStr.trim()];
//                         if (valueNum) value.push(valueNum);
//                     });
//                 };
//             }

//             if (value) addDataInfo[key] = value;
//         }
//         addList.push(addDataInfo);
//     })
    
//     await createPartyInformation(addList);
//     console.log("---> 党建资讯信息 初始化成功");
// }


/**
 * 获取单个excel文件数据
 * @param filePath 
 * @returns 
 */
 function getExcel(filePath) {
    const workSheetsFromFile = xlsx.parse(filePath);
    let sheetMap = {};
    let sheetList = [];

    for (let i = 0; i < workSheetsFromFile.length; i++) {
        let sheetInfo = workSheetsFromFile[i];
        sheetMap[sheetInfo.name] = sheetInfo.data;
        sheetList.push(sheetInfo);
    }

    return {sheetMap, sheetList}  
}








