/**
 * 总路由入口
 */

import * as appletUserRouters from '../routers/applet/user';
import * as appletBaseRouters from '../routers/applet/base';
import * as appletPartyMemberRouters from '../routers/applet/partyMember';
import * as appletBranchSystemRouters from '../routers/applet/branchSystem';
import * as appletOrganizationalLifeRouters from '../routers/applet/organizationalLife';
import * as appletPartyVanguardRouters from '../routers/applet/partyVanguard';
import * as appletPartyExpensesRouters from '../routers/applet/partyExpenses';
import * as appletPartyQualityRouters from '../routers/applet/partyQuality';
import * as partyBuildingDynamicRouters from '../routers/applet/partyBuildingDynamic';
import * as memberLearningRouters from '../routers/applet/memberLearning';

import * as publicRouters from '../routers/public';
import * as abiPartyBuildingRouters from './abi/partyBuilding';
import * as abiTargetRouters from './abi/target';
import * as dwRouters from './applet/dw';

export function setRouter(httpServer){
    /**小程序端 党员入口 */
    appletUserRouters.setRouter(httpServer);
    appletBaseRouters.setRouter(httpServer);
    appletPartyMemberRouters.setRouter(httpServer);
    appletBranchSystemRouters.setRouter(httpServer);
    appletOrganizationalLifeRouters.setRouter(httpServer);
    appletPartyVanguardRouters.setRouter(httpServer);
    appletPartyExpensesRouters.setRouter(httpServer);
    appletPartyQualityRouters.setRouter(httpServer);
    partyBuildingDynamicRouters.setRouter(httpServer);
    memberLearningRouters.setRouter(httpServer);

    /**小程序端 公共资源 */
    publicRouters.setRouter(httpServer);

    /**ABI */
    abiPartyBuildingRouters.setRouter(httpServer);
    abiTargetRouters.setRouter(httpServer);

    dwRouters.setRouter(httpServer);
}