/**
 * 公共资源路由
 */

import * as asyncHandler from 'express-async-handler';
import * as configEnum from "../config/enum";
import * as clientConfigEnum from "../config/clientEnum";
import moment = require('moment');

export function setRouter(httpServer) {
    httpServer.post('/yfs/applet/public/partypositions', asyncHandler(partyPositions));
    httpServer.post('/yfs/applet/public/type', asyncHandler(type));
    httpServer.post('/yfs/applet/public/entrytype', asyncHandler(entryType));
    httpServer.post('/yfs/applet/public/sex', asyncHandler(sexType));
    httpServer.post('/yfs/applet/public/degree', asyncHandler(degreeType));
    httpServer.post('/yfs/applet/public/administrativeposition', asyncHandler(administrativePosition));
    httpServer.post('/yfs/applet/public/department', asyncHandler(department));
    httpServer.post('/yfs/applet/public/honortype', asyncHandler(honorType));
    httpServer.post('/yfs/applet/public/themetype', asyncHandler(themeType));
    httpServer.post('/yfs/applet/public/paytype', asyncHandler(payType));
    httpServer.post('/yfs/applet/public/paytime', asyncHandler(getPayTime));
    httpServer.post('/yfs/applet/public/coursetype', asyncHandler(courseType));
    httpServer.post('/yfs/applet/public/activitytype', asyncHandler(activityType));
    httpServer.post('/yfs/applet/public/grantingrange', asyncHandler(grantingRange));
    httpServer.post('/yfs/applet/public/personhonortype', asyncHandler(personhonortype));
    httpServer.post('/yfs/public/entrytype', asyncHandler(entryType));

    httpServer.post('/yfs/public/branchname', asyncHandler(branchname));
    httpServer.post('/yfs/public/age', asyncHandler(age));
}


function age(req, res) {
    let dataList = [];
    dataList.push({key:"0-5年", value:1})
    dataList.push({key:"5-10年", value:2})
    dataList.push({key:"10-15年", value:3})
    dataList.push({key:"15-20年", value:4})
    dataList.push({key:"20年以上", value:5});

    res.success({dataList})
}

function branchname(req, res) {
    let dataList = getEnumList(configEnum.BRANCHNAME);
    res.success(dataList);
}


function personhonortype(req, res) {
    let dataList = getEnumList(configEnum.PERSONHONORTYPE);
    res.success(dataList);
}



function grantingRange(req, res) {
    let dataList = getEnumList(configEnum.GRANTINGRANGE);
    res.success(dataList);
}




/**
 * 
 * @param req 
 * @param res 
 */
function activityType(req, res) {
    let dataList = getEnumList(configEnum.ACTIVITIESTYPE);
    res.success(dataList);
}



/**
 * 党内职务
 * @param req 
 * @param res 
 */
function partyPositions(req, res) {
    let dataList = getEnumList(configEnum.PARTYPOSITIONS);
    res.success(dataList);
}


/**
 * 组织生活活动类型
 * @param req  
 * @param res 
 */
 function type(req, res) {
    let dataList = getEnumList(clientConfigEnum.TYPE);
    res.success(dataList);
}


/**
 * 组织生活主题类型
 * @param req 
 * @param res 
 */
function themeType(req, res) {
    let dataList = getEnumList(configEnum.THEMETYPE);
    dataList.unshift({key:"全部活动", value: 0});
    res.success(dataList);
}



/**
 * 名册录入类型
 * @param req  
 * @param res 
 */
 function entryType(req, res) {
    let dataList = getEnumList(clientConfigEnum.ENTRYTYPE);
    res.success(dataList);
}


/**
 * 性别类型
 * @param req 
 * @param res 
 */
function sexType(req, res) {
    let dataList = getEnumList(configEnum.SEX);
    res.success(dataList);
}


/**
 * 文化程度类型
 * @param req 
 * @param res 
 */
function degreeType(req, res) {
    let dataList = getEnumList(configEnum.DEGREE);
    res.success(dataList);
}


/**
 * 行政职务类型
 * @param req 
 * @param res 
 */
function administrativePosition(req, res) {
    let dataList = getEnumList(configEnum.ADMINISTRATIVEPOSITION);
    res.success(dataList);
}


/**
 * 所属科室类型
 * @param req 
 * @param res 
 */
function department(req, res) {
    let dataList = getEnumList(configEnum.DEDPARTMENT);
    res.success(dataList);
}


/**
 * 荣誉类型
 * @param req 
 * @param res 
 */
function honorType(req, res) {
    let dataList = getEnumList(configEnum.HONORTYPE);
    res.success(dataList);
}


/**
 * 缴纳状态
 * @param req 
 * @param res 
 */
function payType(req, res) {
    let dataList = getEnumList(configEnum.PAYTYPE);
    dataList.unshift({key:"全部", value: 0});
    res.success(dataList);
}


/**
 * 课程类型
 * @param req 
 * @param res 
 */
function courseType(req, res) {
    let dataList = getEnumList(configEnum.COURSETYPE);
    res.success(dataList);
}


/**
 * 下拉年份月份
 * @param req 
 * @param res 
 */
async function getPayTime(req, res) {
    let result = await payTime();
    
    res.success(result);
}


function getEnumList(enumData) {
    let dataList= [];
    for (let key in enumData) {
        let anyKey:any = key;
        if (isNaN(anyKey)) {
            let keyStr = key;
            dataList.push({key:keyStr, value:enumData[key]});
        }
    }

    return dataList;
}



/**
 * 缴纳时间
 */
export function payTime() {
    let smallYear = 2018; //数据开始年份
    let nowYear = parseInt(moment(new Date()).format("YYYY")); //当前年份
    let yearList = [];
    let monthList = [];

    let nowMonth = parseInt(moment(new Date()).format("MM"));
    let yearmonth = [];
    for(let i = 1; i <= nowMonth; i++) {
        yearmonth.push(i);
    }
    monthList.push(yearmonth);

    for(let i = nowYear; i >= smallYear; i--) {
        yearList.push(i);
        let yearmonth = [];
        for(let m = 12; m >= 1; m--){
            yearmonth.push(m);
        }
        monthList.push(yearmonth);
    }

    return {yearList, monthList};
}