/**
 * 小程序端 党员入口 用户基础功能路由
 */

import * as userBiz from '../../biz/user';
import * as asyncHandler from 'express-async-handler';
import { eccReqParamater } from '../../util/verificationParam';
import { checkAppletToken } from '../../middleware/user';

export function setRouter(httpServer) {
    httpServer.post('/yfs/applet/partymember/login', asyncHandler(login));
    httpServer.post('/yfs/applet/partymember/changepwd', checkAppletToken, asyncHandler(changePwd));

    httpServer.post('/yfs/applet/partymember/first/changepwd', checkAppletToken, asyncHandler(first_change_pwd));
}

async function first_change_pwd(req, res) {
    let reqConf = {pwd:'String', confirmation:'String'};
    let {confirmation, pwd} = eccReqParamater(reqConf, req.body);
    const UserId = req.headers.userid;
    let userInfo = await userBiz.firstChangePwd(UserId, pwd, confirmation);
    res.success(userInfo);
}


/**
 * 党员入口登录
 * @param req 
 * @param res 
 */
async function login(req, res) {
    let reqConf = {loginId:'String', pwd:'String'};
    let {loginId, pwd} = eccReqParamater(reqConf, req.body);

    let userInfo = await userBiz.login(loginId, pwd);
    res.success(userInfo);
}


/**
 * 修改密码
 * @param req 
 * @param res 
 */
 async function changePwd(req, res) {
    let reqConf = {confirmPwd:'String', newPwd:'String', pwd:'String' };
    let {confirmPwd, newPwd, pwd} = eccReqParamater(reqConf, req.body);
    const UserId = req.headers.userid;

    let result = await userBiz.changePassword(UserId, pwd, newPwd, confirmPwd); 

    res.success(result);
}