/**
 * 小程序端
 * 党建先锋
 */

import * as partyVanguardBiz from '../../biz/partyVanguard';
import * as asyncHandler from 'express-async-handler';
import { eccReqParamater } from '../../util/verificationParam';
import { checkAppletToken } from '../../middleware/user';

export function setRouter(httpServer) {
  httpServer.post('/yfs/applet/partyvanguard/list', checkAppletToken, asyncHandler(getPartyVanguard));
  httpServer.post('/yfs/applet/partyvanguard/detsils', checkAppletToken, asyncHandler(getPartyVanguardDetsils));
  httpServer.post('/yfs/applet/partyvanguard/add', checkAppletToken, asyncHandler(addPartyVanguardDetsils));
}


 /**  
  * 党建先锋 荣誉列表
  * @param req 
  * @param res 
  */
async function getPartyVanguard(req, res) {
  let reqConf = { honorName:'String'};
  let {honorName} = eccReqParamater(reqConf, req.body, ["honorName"]);

  let bId = req.headers.bId;
  let result = await partyVanguardBiz.partyVanguardList(bId, honorName);
  res.success(result);
}


/**
 * 党建先锋 获取荣誉详情
 * @param req 
 * @param res 
 */
async function getPartyVanguardDetsils(req, res) {
  let reqConf = {pvId:'Number'};
  let {pvId} = eccReqParamater(reqConf, req.body);

  let result = await partyVanguardBiz.partyVanguardDetsils(pvId);
  res.success(result);
}




/**
 * 党建先锋 添加荣誉详情
 * @param req 
 * @param res 
 */
async function addPartyVanguardDetsils(req, res) {
  let reqConf = {param:'Object'};
  let {param} = eccReqParamater(reqConf, req.body);

  let bId = req.headers.bId;

  let result = await partyVanguardBiz.addPartyVanguard(bId, param);
  res.success(result);
}




