/**
 * 小程序端
 * 党建质量指数 三级指标
 */

import * as partyQualityBiz from '../../biz/partyQuality';
import * as asyncHandler from 'express-async-handler';
import { eccReqParamater } from '../../util/verificationParam';
import { checkAppletToken } from '../../middleware/user';

export function setRouter(httpServer) {
    httpServer.post('/yfs/applet/partyquality/list', checkAppletToken, asyncHandler(getPartyQuality));
    httpServer.post('/yfs/applet/partyquality/detsils',checkAppletToken, asyncHandler(getPartyVanguardDetsils));
}


 /**  
  * 党建指标指数 三级指标列表
  * @param req 
  * @param res 
  */
async function getPartyQuality(req, res) {
    let bId = req.headers.bId;
    let result = await partyQualityBiz.partyQualityList(bId);
    res.success(result);
}


/**
 * 党建先锋 获取荣誉详情
 * @param req 
 * @param res 
 */
async function getPartyVanguardDetsils(req, res) {
    let reqConf = {qualityId:'Number'};
    let {qualityId} = eccReqParamater(reqConf, req.body);
    let bId = req.headers.bId;
    let result = await partyQualityBiz.partyQualityInfo(bId, qualityId);
    res.success(result);
}
 
 
 
 
 


