/**
 * 小程序端
 * 党员基础信息
 */

import * as partyMemberBiz from '../../biz/partyMember';
import * as asyncHandler from 'express-async-handler';
import { eccReqParamater } from '../../util/verificationParam';
import { checkAppletToken } from '../../middleware/user';
 
export function setRouter(httpServer) {
    httpServer.post('/yfs/applet/partymember/partymembername', checkAppletToken, asyncHandler(get_party_member_name));
    httpServer.post('/yfs/applet/partymember/detsils', checkAppletToken, asyncHandler(party_detsils));
    httpServer.post('/yfs/applet/partymember/add', checkAppletToken, asyncHandler(add_member));
}
 

/**
  * 党员名册
  * @param req 
  * @param res 
  */
async function get_party_member_name(req, res) {
    let reqConf = {bId:'Number', name:'String'};
    let {bId, name} = eccReqParamater(reqConf, req.body, ["name"]);

    let result = await partyMemberBiz.partyMemberNameList(bId, name);
    res.success(result);
}


/**
 * 党员详情
 * @param req 
 * @param res 
 */
async function party_detsils(req, res) {
    let reqConf = {bId: 'Number', pmId: 'String'};
    let {bId, pmId} = eccReqParamater(reqConf, req.body);

    let result = await partyMemberBiz.partyMemberDetails(bId, pmId);
    res.success(result);
}


/**
 * 添加
 * @param req 
 * @param res 
 */
async function add_member(req, res) {
    let reqConf = {memberType: 'Number', param: 'Object'};
    let {memberType, param} = eccReqParamater(reqConf, req.body);

    let bId = req.headers.bId;
    let result = await partyMemberBiz.addMember(bId, memberType, param);
    
    res.success(result);
}




