/**
 * 小程序端
 * 党费管理
 */

import * as partyExpensesBiz from '../../biz/partyExpenses';
import * as asyncHandler from 'express-async-handler';
import { eccReqParamater } from '../../util/verificationParam';
import { checkAppletToken } from '../../middleware/user';

export function setRouter(httpServer) {
    httpServer.post('/yfs/applet/partyexpenses/list', checkAppletToken, asyncHandler(getPartyExpenses));
    httpServer.post('/yfs/applet/partyexpenses/selflist', checkAppletToken, asyncHandler(getSelfPartyExpenses));
}


/**
* 党费列表
* @param req 
* @param res 
*/
async function getPartyExpenses(req, res) {
    let reqConf = {payableYear:'Number', payType:"Number", payableMonth:'Number'};
    let {payableYear, payableMonth, payType} = eccReqParamater(reqConf, req.body, ["payType"]);
    
    let bId = req.headers.bId;
    let result = await partyExpensesBiz.partyExpensesData(bId, payType, payableYear, payableMonth);
    res.success(result);
}


async function getSelfPartyExpenses(req, res) {
    let reqConf = { payType:"Number"};
    let {payType} = eccReqParamater(reqConf, req.body);
    
    let bId = req.headers.userid;
    let result = await partyExpensesBiz.selfPartyExpensesData(bId, payType);
    res.success(result);
}

