/**
 * 小程序端
 * 党建资讯 请求的是活动表
 */

import * as partyBuildingDynamicBiz from '../../biz/partyBuildingDynamic';
import * as asyncHandler from 'express-async-handler';
import { eccReqParamater } from '../../util/verificationParam';
import { checkAppletToken } from '../../middleware/user';

export function setRouter(httpServer) {
    httpServer.post('/yfs/applet/buildingdynamic/list', checkAppletToken, asyncHandler(partyBuildingDynamicList));
    httpServer.post('/yfs/applet/buildingdynamic/details', checkAppletToken, asyncHandler(detailsList));

    httpServer.post('/yfs/applet/dynamics/details', checkAppletToken, asyncHandler(dynamics_details));//党建动态
}



/**
 * 党建动态
 * @param req 
 * @param res 
 */
async function dynamics_details(req, res) {
    let reqConf = {pbId: 'Number'};
    let {pbId} = eccReqParamater(reqConf, req.body);

    let result = await partyBuildingDynamicBiz.dynamicsDetails(pbId);
    res.success(result);
}



/**
 * 党建资讯列表
 * @param req 
 * @param res 
 */
async function partyBuildingDynamicList(req, res) {
    let reqConf = {activitiesType:'Number'};
    let {activitiesType} = eccReqParamater(reqConf, req.body);

    let bId = req.headers.bId;

    let result = await partyBuildingDynamicBiz.partyBuildingDynamicList(bId, activitiesType);
    res.success(result);
}


/**
 * 党建动态详情
 * @param req 
 * @param res 
 */
async function detailsList(req, res) {
    let reqConf = {taId: 'Number'};
    let {taId} = eccReqParamater(reqConf, req.body);

    let result = await partyBuildingDynamicBiz.partyBuildingDynamicDetsils(taId);
    res.success(result);
}
 
 


