/**
 * 小程序端
 * 组织生活路由
 */

import * as organizationalLifeBiz from '../../biz/organizationalLife';
import * as asyncHandler from 'express-async-handler';
import { eccReqParamater } from '../../util/verificationParam';
import { checkAppletToken } from '../../middleware/user';

export function setRouter(httpServer) {
    httpServer.post('/yfs/applet/organizationallife/list', checkAppletToken, asyncHandler(organizationalLifeList));
    httpServer.post('/yfs/applet/organizationallife/details', checkAppletToken, asyncHandler(details));
    httpServer.post('/yfs/applet/organizationallife/add', checkAppletToken, asyncHandler(addDetails));
    httpServer.post('/yfs/applet/organizationallife/update', checkAppletToken, asyncHandler(updateDetails));
    httpServer.post('/yfs/applet/organizationallife/memberlist', checkAppletToken, asyncHandler(memberlist));
    httpServer.post('/yfs/applet/organizationallife/delete', checkAppletToken, asyncHandler(deleteDetails));
}

/**
 * 
 * @param req 
 * @param res 
 */
async function deleteDetails(req, res) {
    let reqConf = {oId:"Number"};
    let {oId} = eccReqParamater(reqConf, req.body);
    let bId = req.headers.bId;
    let result = await organizationalLifeBiz.delOrg(oId);
    res.success(result);
}



/**
 * 组织生活列表
 * @param req 
 * @param res 
 */
async function organizationalLifeList(req, res) {
    let reqConf = {theme:'String', themeType:'Number'};
    let {theme, themeType} = eccReqParamater(reqConf, req.body, ["theme","themeType"]);

    let bId = req.headers.bId;
    let result = await organizationalLifeBiz.organizationalLifeList(bId, theme, themeType);
    res.success(result);
}


/**
 * 组织生活详情
 * @param req 
 * @param res 
 */
async function details(req, res) {
    let reqConf = {oId: 'Number' };
    let {oId} = eccReqParamater(reqConf, req.body);

    let token = req.headers.token;
    let userid = req.headers.userid;
    let bId = req.headers.bId;

    let result = await organizationalLifeBiz.organlzationalLifeListDetsils(oId, token, userid, bId);
    res.success(result);
}


/**
 * 
 * @param req 
 * @param res 
 */
async function addDetails(req, res) {
    let reqConf = {param:"Object"};
    let {param} = eccReqParamater(reqConf, req.body);
    let bId = req.headers.bId;
    let result = await organizationalLifeBiz.addOrg(bId, param);
    res.success(result);
}


/**
 * 
 * @param req 
 * @param res 
 */
async function updateDetails(req, res) {
    let reqConf = {oId:"Number", param:"Object"};
    let {oId, param} = eccReqParamater(reqConf, req.body);
    let bId = req.headers.bId;
    let result = await organizationalLifeBiz.updateOrg(oId, param);
    res.success(result);
}


async function memberlist(req, res) {
    let bId = req.headers.bId;
    let result = await organizationalLifeBiz.memberSelect(bId);
    res.success(result);
}