/**
 * 小程序端
 * 党员学习
 */

import * as memberLearningBiz from '../../biz/memberLearning';
import * as asyncHandler from 'express-async-handler';
import { eccReqParamater } from '../../util/verificationParam';
import { checkAppletToken } from '../../middleware/user';

export function setRouter(httpServer) {
    httpServer.post('/yfs/applet/memberlearning/list', checkAppletToken, asyncHandler(getMemberLearning));
    httpServer.post('/yfs/applet/memberlearning/branchranking', checkAppletToken, asyncHandler(getBranchRanking));
    httpServer.post('/yfs/applet/memberlearning/ranking', checkAppletToken, asyncHandler(getRanking));
    httpServer.post('/yfs/applet/memberlearning/updateschedule', checkAppletToken, asyncHandler(updateRateLearning));
    httpServer.post('/yfs/applet/memberlearning/updatefileschedule', checkAppletToken, asyncHandler(updateFileRateLearning));
}


/**  
  * 本人 视频课程与文字课程列表
  * @param req 
  * @param res 
  */
async function getMemberLearning(req, res) {
    let pmId = req.headers.userid;
    let reqConf = {courseEntryType:'Number', courseTypeName:'Number', contentTitle:'String'};
    let {courseEntryType, courseTypeName, contentTitle} = eccReqParamater(reqConf, req.body, ["contentTitle"]);

    let token = req.headers.token;
    let userid = req.headers.userid;

    let result = await memberLearningBiz.memberLearningList(pmId, courseEntryType, courseTypeName, contentTitle, token, userid);
    res.success(result);
}


/**
 * 学习强国 支部学习排行
 * @param req 
 * @param res 
 */
async function getBranchRanking(req, res) {
  let pmId = req.headers.userid;
  let bId = req.headers.bId;

  let result = await memberLearningBiz.branchRanking(pmId, bId);
  res.success(result);
}


/**
 * 学习强国 本月学习排行
 * @param req 
 * @param res 
 */
async function getRanking(req, res) {
  let pmId = req.headers.userid;
  let result = await memberLearningBiz.branchRanking(pmId);
  res.success(result);
}


/**
 * 修改学习进度
 * @param req 
 * @param res 
 */
async function updateRateLearning(req, res) {
  let reqConf = {rlId:'Number', rateOfLearning:'Number'};
  let {rlId, rateOfLearning} = eccReqParamater(reqConf, req.body);

  let result = await memberLearningBiz.updateRateOfLearning(rlId, rateOfLearning);
  res.success(result);
}


/**
 * 修改学习进度 文档学习
 * @param req 
 * @param res 
 */
async function updateFileRateLearning(req, res) {
  let reqConf = {rlId:'Number', fileName:'String'};
  let {rlId, fileName} = eccReqParamater(reqConf, req.body);

  let result = await memberLearningBiz.updateDocRateOfLearning(rlId, fileName);
  res.success(result);
}









