import { eccReqParamater } from '../../util/verificationParam';
import { checkAppletToken, checkAppletDWToken } from '../../middleware/user';
import * as asyncHandler from 'express-async-handler';
import * as dwBiz from '../../biz/dw';


export function setRouter(httpServer) {

    //总支部权限
    //名册
    httpServer.post('/yfs/dw/home', checkAppletDWToken, asyncHandler(homeBase));
    httpServer.post('/yfs/dw/activities', checkAppletDWToken, asyncHandler(activitiesBase));

    httpServer.post('/yfs/dw/member/partymember/list', checkAppletDWToken, asyncHandler(partymember_list));
    httpServer.post('/yfs/dw/member/partymember/list/sublist', checkAppletDWToken, asyncHandler(partymember_sublist));
    httpServer.post('/yfs/dw/member/partymember/typelist', checkAppletDWToken, asyncHandler(partymember_type_list));
    // httpServer.post('/yfs/dw/member/partymember/typelist/sublist', checkAppletDWToken, asyncHandler());
    httpServer.post('/yfs/dw/member/partymember/add', checkAppletDWToken, asyncHandler(partymember_add));
    httpServer.post('/yfs/dw/notice/list', checkAppletDWToken, asyncHandler(party_notice_ist));

    httpServer.post('/yfs/dw/applet/partyexpenses/list', checkAppletDWToken, asyncHandler(partyexpenses_list));
    httpServer.post('/yfs/dw/applet/partyexpenses/branchlist', checkAppletDWToken, asyncHandler(partyexpenses_branch_list));
    httpServer.post('/yfs/dw/applet/partyexpenses/member/paylist', checkAppletDWToken, asyncHandler(partyexpenses_pay_member_list));
    httpServer.post('/yfs/dw/applet/partyexpenses/member/notpaylist', checkAppletDWToken, asyncHandler(partyexpenses_notpay_member_list));

    httpServer.post('/yfs/dw/applet/branchsystem/list', checkAppletDWToken, asyncHandler(get_branch_system));
    httpServer.post('/yfs/dw/applet/branchsystem/add', checkAppletDWToken, asyncHandler(add_branch_system));
    // httpServer.post('/yfs/applet/branchsystem/detsils', checkAppletToken, asyncHandler(getBranchSystemDetsils));

    // httpServer.post('/yfs/dw/applet/branchsystem/add', checkAppletDWToken, asyncHandler(add_branch_system));

    httpServer.post('/yfs/dw/applet/organizationallife/list', checkAppletDWToken, asyncHandler(organizational_life_list));
    httpServer.post('/yfs/dw/applet/organizationallife/add', checkAppletDWToken, asyncHandler(add_details));

    httpServer.post('/yfs/dw/applet/partyvanguard/list', checkAppletDWToken, asyncHandler(get_party_vanguard));
    httpServer.post('/yfs/dw/applet/partyvanguard/detsils', checkAppletDWToken, asyncHandler(get_party_vanguard_detsils));
    httpServer.post('/yfs/dw/applet/partyvanguard/add', checkAppletDWToken, asyncHandler(add_party_vanguard_detsils));


    httpServer.post('/yfs/dw/applet/buildingdynamic/list', checkAppletDWToken, asyncHandler(partyBuildingDynamicList));
    httpServer.post('/yfs/dw/applet/buildingdynamic/details', checkAppletDWToken, asyncHandler(detailsList));
    

    httpServer.post('/yfs/dw/applet/partyquality/list', checkAppletToken, asyncHandler(getPartyQuality));
    httpServer.post('/yfs/dw/applet/partyquality/detsils',checkAppletToken, asyncHandler(getPartyVanguardDetsils));
}

 /**  
  * 党建指标指数 三级指标列表
  * @param req 
  * @param res 
  */
async function getPartyQuality(req, res) {
    let result = await dwBiz.partyQualityList();
    res.success(result);
}


/**
 * 党建先锋 获取荣誉详情
 * @param req 
 * @param res 
 */
async function getPartyVanguardDetsils(req, res) {
    let reqConf = {qualityId:'Number'};
    let {qualityId} = eccReqParamater(reqConf, req.body);
    let result = await dwBiz.partyQualityInfo(qualityId);
    res.success(result);
}


/**
 * 党建资讯列表
 * @param req 
 * @param res 
 */
async function partyBuildingDynamicList(req, res) {
    let reqConf = {activitiesType:'Number'};
    let {activitiesType} = eccReqParamater(reqConf, req.body);

    let result = await dwBiz.partyBuildingDynamicList(activitiesType);
    res.success(result);
}


/**
 * 党建动态详情
 * @param req 
 * @param res 
 */
async function detailsList(req, res) {
    let reqConf = {taId: 'Number'};
    let {taId} = eccReqParamater(reqConf, req.body);

    let result = await dwBiz.partyBuildingDynamicDetsils(taId);
    res.success(result);
}
 
 




/**
 * 
 * @param req 
 * @param res 
 */
async function homeBase(req, res) {
    let baseInfo = await dwBiz.homeData();
    res.success(baseInfo);
}


/**
 * 
 * @param req 
 * @param res 
 */
async function activitiesBase(req, res) {
    let activitiesInfo = await dwBiz.activitiesData();
    res.success(activitiesInfo);
}


/**
 * 
 * @param req 
 * @param res 
 */
async function partymember_list(req, res) {
    let activitiesInfo = await dwBiz.partymemberList();
    res.success(activitiesInfo);
}

async function partymember_sublist(req, res) {
    let reqConf = {bId:'Number', name:"String", duration:"Number", memberType:"Number", departmentName:"Number"};
    let {bId, name, duration, memberType, departmentName} = eccReqParamater(reqConf, req.body, ["name", "duration", "memberType", "departmentName"]);
    let activitiesInfo = await dwBiz.partymemberSublist(bId, name, duration, memberType, departmentName);
    res.success(activitiesInfo);
}


/**
 * 
 * @param req 
 * @param res 
 */
async function partymember_type_list(req, res) {
    let reqConf = {bId:'Number'};
    let {bId} = eccReqParamater(reqConf, req.body);

    let activitiesInfo = await dwBiz.partymemberTypeList(bId);
    res.success(activitiesInfo);
}


async function partymember_add(req, res) {
    let reqConf = {bId:'Number', memberType:'Number', param:'Object'};
    let {bId, param, memberType} = eccReqParamater(reqConf, req.body);

    let activitiesInfo = await dwBiz.addMember(bId, memberType, param);
    res.success(activitiesInfo);
}


async function party_notice_ist(req, res) {
    let activitiesInfo = await dwBiz.partyNoticeList();
    res.success(activitiesInfo);
}



async function partyexpenses_list(req, res) {
    let reqConf = {payableYear:'Number', payableMonth:'Number'};
    let {payableYear, payableMonth} = eccReqParamater(reqConf, req.body);

    let activitiesInfo = await dwBiz.partyexpensesList(payableYear, payableMonth);
    res.success(activitiesInfo);
}


async function partyexpenses_branch_list(req, res) {
    let reqConf = {payableYear:'Number', payableMonth:'Number', payType:'Number', bId:'Number'};
    let {payableYear, payableMonth,payType, bId} = eccReqParamater(reqConf, req.body);

    let activitiesInfo = await dwBiz.partyexpensesBranchList(bId, payType, payableYear, payableMonth);
    res.success(activitiesInfo);
}


async function partyexpenses_pay_member_list(req, res) {
    let reqConf = {name:"String", duration:"Number", departmentName:"Number"};
    let {bId, name, duration, departmentName} = eccReqParamater(reqConf, req.body, ["name", "duration", "departmentName"]);

    let activitiesInfo = await dwBiz.partyexpensesMemberList(1, bId, name, duration, departmentName);
    res.success(activitiesInfo);
}

async function partyexpenses_notpay_member_list(req, res) {
    let reqConf = { name:"String", duration:"Number", departmentName:"Number"};
    let {bId, name, duration, departmentName} = eccReqParamater(reqConf, req.body, ["name", "duration", "departmentName"]);

    let activitiesInfo = await dwBiz.partyexpensesMemberList(2, bId, name, duration, departmentName);
    res.success(activitiesInfo);
}


async function get_branch_system(req, res) {
    let reqConf = { systemTitle:"String"};
    let {systemTitle} = eccReqParamater(reqConf, req.body, ["systemTitle"]);

    let activitiesInfo = await dwBiz.branchSystemList(systemTitle);
    res.success(activitiesInfo);
}


async function add_branch_system(req, res) {
    let reqConf = { param:"Object"};
    let {param} = eccReqParamater(reqConf, req.body, []);

    let activitiesInfo = await dwBiz.addOneBranchSystemDetsils(param);
    res.success(activitiesInfo);
}


async function organizational_life_list(req, res) {
    let reqConf = { theme:"String", themeType:"Number"};
    let {theme, themeType} = eccReqParamater(reqConf, req.body, []);

    let activitiesInfo = await dwBiz.organizationalLifeList(theme, themeType);
    res.success(activitiesInfo);
}

async function add_details(req, res) {
    let reqConf = {param:"Object"};
    let {param} = eccReqParamater(reqConf, req.body);
    let result = await dwBiz.addOrg(param);
    res.success(result);
}


 /**  
  * 党建先锋 荣誉列表
  * @param req 
  * @param res 
  */
async function get_party_vanguard(req, res) {
  let reqConf = { honorName:'String'};
  let {honorName} = eccReqParamater(reqConf, req.body, ["honorName"]);

  let result = await dwBiz.dwPartyVanguardList( honorName);
  res.success(result);
}


/**
 * 党建先锋 获取荣誉详情
 * @param req 
 * @param res 
 */
async function get_party_vanguard_detsils(req, res) {
  let reqConf = {pvId:'Number'};
  let {pvId} = eccReqParamater(reqConf, req.body);

  let result = await dwBiz.dwPartyVanguardDetsils(pvId);
  res.success(result);
}




/**
 * 党建先锋 添加荣誉详情
 * @param req 
 * @param res 
 */
async function add_party_vanguard_detsils(req, res) {
  let reqConf = {param:'Object'};
  let {param} = eccReqParamater(reqConf, req.body);

  let bId = req.headers.bId;

  let result = await dwBiz.addDWPartyVanguard(bId, param);
  res.success(result);
}




