/**
 * 小程序端
 * 支部制度
 */

 import * as branchSystemBiz from '../../biz/branchSystem';
 import * as asyncHandler from 'express-async-handler';
 import { eccReqParamater } from '../../util/verificationParam';
import { checkAppletToken } from '../../middleware/user';
 
export function setRouter(httpServer) {
    httpServer.post('/yfs/applet/branchsystem/list', checkAppletToken, asyncHandler(getBranchSystem));
    httpServer.post('/yfs/applet/branchsystem/detsils', checkAppletToken, asyncHandler(getBranchSystemDetsils));
    httpServer.post('/yfs/applet/branchsystem/add', checkAppletToken, asyncHandler(addBranchSystemDetsils));
}
 

 /**
  * 支部制度 制度列表
  * @param req 
  * @param res 
  */
async function getBranchSystem(req, res) {
    let reqConf = { systemTitle:'String'};
    let { systemTitle} = eccReqParamater(reqConf, req.body, ["systemTitle"]);
    let bId = req.headers.bId;

    let result = await branchSystemBiz.branchSystemList(bId, systemTitle);
    res.success(result);
}


/**
 * 支部制度 制度细则
 * @param req 
 * @param res 
 */
async function getBranchSystemDetsils(req, res) {
    let reqConf = {bsId: 'Number'};
    let {bsId} = eccReqParamater(reqConf, req.body);
    let result = await branchSystemBiz.branchSystemDetsils(bsId);
    res.success(result);
}

/**
 * 支部制度 制度细则
 * @param req 
 * @param res 
 */
async function addBranchSystemDetsils(req, res) {
    let reqConf = {param: 'Object'};
    let {param} = eccReqParamater(reqConf, req.body);
    let bId = req.headers.bId;
    let result = await branchSystemBiz.addOneBranchSystemDetsils(bId, param);
    res.success(result);
}


