/**
 * 小程序端 
 * 党建首页路由
 */

import * as baseBiz from '../../biz/base';
import * as asyncHandler from 'express-async-handler';
import { eccReqParamater } from '../../util/verificationParam';
import { checkAppletToken } from '../../middleware/user';

export function setRouter(httpServer) {
    httpServer.post('/yfs/applet/partymember/home', checkAppletToken, asyncHandler(homeBase));
    httpServer.post('/yfs/applet/partymember/activities', checkAppletToken, asyncHandler(activitiesBase));

    httpServer.post('/yfs/member/partymember/home', checkAppletToken, asyncHandler(member_home));
    httpServer.post('/yfs/member/partymember/bottomhome', checkAppletToken, asyncHandler(member_home_bottom));
}


/**
 * 党建首页基础数据
 * @param req 
 * @param res 
 */
async function homeBase(req, res) {
    let bId = req.headers.bId;
    let baseInfo = await baseBiz.homeData(bId);
    res.success(baseInfo);
}


/**
 * 党建首页党建资讯列表
 * @param req 
 * @param res 
 */
async function activitiesBase(req, res) {
    let bId = req.headers.bId;

    let activitiesInfo = await baseBiz.activitiesData(bId);
    res.success(activitiesInfo);
}


async function member_home(req, res) {
    let userid = req.headers.userid;
    let bId = req.headers.bId; 

    let activitiesInfo = await baseBiz.memberHomeData(userid, bId);
    res.success(activitiesInfo);
}



async function member_home_bottom(req, res) {
    let reqConf = { activitiesType:'Number'};
    let { activitiesType } = eccReqParamater(reqConf, req.body);
    let bId = req.headers.bId; 

    let activitiesInfo = await baseBiz.memberHomeBottomData(bId, activitiesType);
    res.success(activitiesInfo);
}
