/**
 * 小程序端 
 * 党建首页路由
 */

import * as adminBiz from '../biz/admin';
import * as asyncHandler from 'express-async-handler';
import { eccReqParamater } from '../util/verificationParam';
import { checkAdminToken } from '../middleware/user';

export function setRouter(httpServer) {
    httpServer.post('/yfs/admin/login', asyncHandler(login));
    httpServer.post('/yfs/admin/logout', asyncHandler(logout));
    httpServer.post('/yfs/admin/zzjg', checkAdminToken, asyncHandler(zzjg));//组织机构
    httpServer.post('/yfs/admin/dyxx/list', checkAdminToken, asyncHandler(dyxx_list));
    httpServer.post('/yfs/admin/dyxx/change', checkAdminToken, asyncHandler(dyxx_change));
    // httpServer.post('/yfs/admin/dyxx/add', checkAdminToken, asyncHandler(dyxx_add));
    // httpServer.post('/yfs/admin/dfgl/list', checkAdminToken, asyncHandler(dfgl_list));
    // httpServer.post('/yfs/admin/dfgl/add', checkAdminToken, asyncHandler(dfgl_add));
    // httpServer.post('/yfs/admin/dfgl/del', checkAdminToken, asyncHandler(dfgl_del));
    // httpServer.post('/yfs/admin/dfgl/sublist', checkAdminToken, asyncHandler(dfgl_sublist));
}

async function login(req, res) {
    let reqConf = {pwd:'String', loginId:'String'};
    let {loginId, pwd} = eccReqParamater(reqConf, req.body);
    const UserId = req.headers.userid;
    let userInfo = await adminBiz.login(loginId, pwd);
    res.success(userInfo);
}

async function logout(req, res) {
    const UserId = req.headers.userid;
    let userInfo = await adminBiz.logOut(UserId);
    res.success(userInfo);
}

async function zzjg(req, res) {
    let userInfo = await adminBiz.zzjgList();
    res.success(userInfo);

}
async function dyxx_list(req, res) {
    let reqConf = {etId:"Number", str:"String", bId:"Number", startMs:"Number", endMs:"Number", page:"Number"};
    let {etId, str, bId, startMs, endMs, page} = eccReqParamater(reqConf, req.body, ["str", "bId", "startMs", "endMs"]);
    let userInfo = await adminBiz.dyxxList(etId, str, bId, startMs, endMs, page);
    res.success(userInfo);
}

async function dyxx_change(req, res) {
    // let reqConf = {pmId:'String', confirmation:'String'};
    // let {confirmation, pwd} = eccReqParamater(reqConf, req.body);
    // const UserId = req.headers.userid;
    // let userInfo = await adminBiz.firstChangePwd(UserId, pwd, confirmation);
    // res.success(userInfo);

}


// async function dyxx_add(req, res) {
//     let reqConf = {pwd:'String', confirmation:'String'};
//     let {confirmation, pwd} = eccReqParamater(reqConf, req.body);
//     const UserId = req.headers.userid;
//     let userInfo = await userBiz.firstChangePwd(UserId, pwd, confirmation);
//     res.success(userInfo);

// }
// async function dfgl_list(req, res) {
//     let reqConf = {pwd:'String', confirmation:'String'};
//     let {confirmation, pwd} = eccReqParamater(reqConf, req.body);
//     const UserId = req.headers.userid;
//     let userInfo = await userBiz.firstChangePwd(UserId, pwd, confirmation);
//     res.success(userInfo);

// }
// async function dfgl_add(req, res) {
//     let reqConf = {pwd:'String', confirmation:'String'};
//     let {confirmation, pwd} = eccReqParamater(reqConf, req.body);
//     const UserId = req.headers.userid;
//     let userInfo = await userBiz.firstChangePwd(UserId, pwd, confirmation);
//     res.success(userInfo);

// }
// async function dfgl_del(req, res) {
//     let reqConf = {pwd:'String', confirmation:'String'};
//     let {confirmation, pwd} = eccReqParamater(reqConf, req.body);
//     const UserId = req.headers.userid;
//     let userInfo = await userBiz.firstChangePwd(UserId, pwd, confirmation);
//     res.success(userInfo);

// }
// async function dfgl_sublist(req, res) {
//     let reqConf = {pwd:'String', confirmation:'String'};
//     let {confirmation, pwd} = eccReqParamater(reqConf, req.body);
//     const UserId = req.headers.userid;
//     let userInfo = await userBiz.firstChangePwd(UserId, pwd, confirmation);
//     res.success(userInfo);

// }