/**
 * abi接口——党建分析
 */

import * as partyBuildingBiz from '../../biz/abi/partyBuilding';
import * as asyncHandler from 'express-async-handler';
import { eccReqParamater } from '../../util/verificationParam';

export function setRouter(httpServer) {
    httpServer.post('/yfs/abi/partybuilding/leftscreen', asyncHandler(leftScreen));
    httpServer.post('/yfs/abi/partybuilding/midscreen', asyncHandler(midScreen));
    httpServer.post('/yfs/abi/partybuilding/rightscreen', asyncHandler(rightScreen));
}


async function leftScreen(req, res) {
    let result = await partyBuildingBiz.getLeftScreen();
    res.success(result);
}


async function midScreen(req, res) {
    let {year} = eccReqParamater({year:'String'}, req.body);
    let result = await partyBuildingBiz.getMidScreen(year);
    res.success(result)
}



async function rightScreen(req, res) {
    let result = await partyBuildingBiz.getRightScreen();
    res.success(result);
}