import { OPERATIONALDATATYPE, TABLENAME } from "../config/dbEnum";
import { PARTYPOSITIONS } from "../config/enum";
import { ERRORCODEENUM, ERRORENUM } from "../config/errorEnum";
import { BizError } from "../util/bizError";
import { selectData } from "./databaseSuccess";

/**
 * 中间件 校验小程序token
 * @param req 
 * @param res 
 * @param next 
 * @returns 
 */
export async function checkAppletToken(req, res, next) {
    
    if (!req.headers) req.headers = {};
    let ReqToken = req.headers.token;
    let UserId = req.headers.userid;

    if(!UserId || !ReqToken) return next(new BizError(ERRORENUM.非法登录));

    let partyMemberInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.党员基础信息表, {pmId: UserId}, ["pmId", "bId", "loginId", "token"]);
    if (!partyMemberInfo || !partyMemberInfo.pmId) return next(new BizError(ERRORENUM.身份验证失败));
    if (!partyMemberInfo.token || partyMemberInfo.token != ReqToken) return next(new BizError(ERRORENUM.身份验证过期));

    req.headers.userid = partyMemberInfo.pmId;
    req.headers.bId = partyMemberInfo.bId;
    
    next();
}


export async function checkAppletDWToken(req, res, next) {
     if (!req.headers) req.headers = {};
    let ReqToken = req.headers.token;
    let UserId = req.headers.userid;

    if(!UserId || !ReqToken) return next(new BizError(ERRORENUM.非法登录));

    let partyMemberInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.党员基础信息表, {pmId: UserId}, ["pmId", "bId", "loginId", "token", "partyPositionsName"]);
    if (!partyMemberInfo || !partyMemberInfo.pmId) return next(new BizError(ERRORENUM.身份验证失败));
    if (!partyMemberInfo.token || partyMemberInfo.token != ReqToken) return next(new BizError(ERRORENUM.身份验证过期));

    req.headers.userid = partyMemberInfo.pmId;
    req.headers.bId = partyMemberInfo.bId;
    
    //判断是否是领导
    let isZZB = false;
    JSON.parse(partyMemberInfo.partyPositionsName).forEach(itemId => {
        if (itemId >= PARTYPOSITIONS.党总支书记 && itemId <= PARTYPOSITIONS.党总支纪检委员) {
            isZZB = true;
        }
    });
    if (!isZZB) {
        throw new BizError(ERRORENUM.权限不足);
    }

    next();
}

export async function checkAdminToken(req, res, next) {
    
    if (!req.headers) req.headers = {};
    let ReqToken = req.headers.token;
    let UserId = req.headers.userid;

    if(!UserId || !ReqToken) return next(new BizError(ERRORENUM.非法登录));

    let partyMemberInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.党员基础信息表, {pmId: UserId}, ["pmId", "bId", "loginId", "token"]);
    if (!partyMemberInfo || !partyMemberInfo.pmId) return next(new BizError(ERRORENUM.身份验证失败));
    if (!partyMemberInfo.token || partyMemberInfo.token != ReqToken) return next(new BizError(ERRORENUM.身份验证过期));

    req.headers.userid = partyMemberInfo.pmId;
    req.headers.bId = partyMemberInfo.bId;
    
    next();
}