/**
 * 获取数据层接口地址
 */
import { FILETYPE } from "../config/enum";
import { systemConfig } from "../config/systemConfig";

export enum urlEnum {
    添加数据 = "/yfs/dataserver/table/add",
    删除数据 = "/yfs/dataserver/table/delete",
    修改单个数据 = "/yfs/dataserver/table/update/one",
    修改多个数据 = "/yfs/dataserver/table/update/many",
    查询单个数据 = "/yfs/dataserver/table/find/one",
    查询多个数据 = "/yfs/dataserver/table/find/many",
    分页查询 = "/yfs/dataserver/table/find/manytopage",
    查询数据数量 = "/yfs/dataserver/table/find/count",
    聚合查询 = "/yfs/dataserver/table/find/aggragate",
}


export function getUrl(url, urlName) {
    return `${url}${urlName}`
}


/**
 * 获取文件预览地址
 * @param data 
 * @param token 
 * @param userid 
 * @returns 
 */
export function getFileUrl(data, token, fileType, userid) {
    let fileNameInfo = JSON.parse(data);
    let fileNameList = [];
    for(let i = 0; i < fileNameInfo.length; i++) {
        fileNameList.push(`${systemConfig.fileIP}/yfs/files/${fileType}/${fileNameInfo[i]}?token=${token}&userid=${userid}`);
    }

    return fileNameList;
}

