const path = require('path');
import * as fs from "fs";
import { BizError } from "../util/bizError";
import { analysisXml } from "../util/myXML";
import { ServerConfig } from "./systemClass";
const os = require('os');

/**被系统使用的配置 */
export let systemConfig =  new ServerConfig;

const ConfigName = "serverConfig.xml";
export async function initConfig() {
    try {
        let buff = fs.readFileSync(path.join(__dirname.substring(0,__dirname.indexOf("out")), ConfigName));
        let configStr = buff.toString();
        let configInfo:any = await analysisXml(configStr);
		if (!configInfo || !configInfo.config) throw new BizError('xml中无配置');
		else {
            
            let { port, db, imgUrl, fileIP } = configInfo.config;
            systemConfig.port = parseInt(port[0]);
            /**数据读写服务 */
            systemConfig.dbPath = db[0].url[0];
            systemConfig.dbSign = db[0].sign[0];

            /**图片地址 */
            systemConfig.imgUrl = imgUrl[0];

            /**文件服务地址 */
            systemConfig.fileIP = fileIP[0];
		}
        
        console.log("config init success");

    } catch(err) {
        console.log('ERROR => 服务器配置解析错误 请检查根目录下 serverConfig.xml 文件是否正确');
        console.log(err);
        throw new BizError("服务器配置解析错误 请检查根目录下 serverConfig.xml 文件是否正确");
    }
}

function analysisMongoConnectStr(path, port, dataBase, w, timeOutMs) {
    return `mongodb://${path}:${port}/${dataBase}?w=${w}&wtimeoutMS=${timeOutMs}`
}
 
export function getEnum() {
    
}