/**
 * 拆分返回结果配置
 * 使用场景：逻辑层中需要返回数据给客户端的地方
 * 限制：使用端不同不能共用一份配置
 */


/**
 * 使用端:   小程序_党员入口
 * 场景:     首页党建资讯列表
 */
export const partyInformationConfig = {
    taId:{key:"taId"},
    theme:{key:"资讯标题"},
    branchName:{key:"支部名称"},
    dataMonth:{key:"资讯时间"},
    // pbType:{key:"资讯类型"},
};


/**
 * 使用端:   小程序_党员入口
 * 场景:     首页党建资讯列表
 */
export const buildingDynamiconfig = {
    pbId:{key:"taId"},
    theme:{key:"资讯标题"},
    branchName:{key:"支部名称"},
    dataMonth:{key:"资讯时间"},
    // pbType:{key:"资讯类型"},
};


/**
 * 使用端:   小程序_党员入口
 * 场景:     党员名称
 * 备注:     党建名册的党员名册
 */
export const partyMemberConfig = {
    pmId:{key:"pmId"},
    name:{key:"姓名"},
    etId:{key:"名册录入类型"},
    partyPositionsName:{key:"党内职务"},
    partyStanding:{key: "党龄"},
    departmentName:{key:"所属科室"},
    color:{key:"颜色"},
}


/**
 * 使用端:   小程序_党员入口
 * 场景:     党员详情
 */
 export const partyMemberDetailsConfig = {
    etId:{key:"名册录入类型"},
    name:{key:"姓名"},
    partyPositionsName:{key:"党内职务"},
    partyStanding:{key: "党龄"},
    departmentName:{key:"所属科室"},
    study:{key:"学习情况"},
    sex:{key:"性别"},
    birthDate:{key:"出生年月", changeDate:true},
    phone:{key:"手机号码"},
    levelOfEducation:{key:"文化程度"},
    partyJoiningTime:{key:"入党时间", changeDate:true},
    administrativePositionName:{key:"行政职务"},
    partyState:{key:"党员状态"},
    color:{key:"颜色"},
}


/**
 * 使用端:   小程序_党员入口
 * 场景:     入党积极分子详情
 */
 export const activistDetailsConfig = {
    etId:{key:"名册录入类型"},
    name:{key:"姓名"},
    partyPositionsName:{key:"党内职务"},
    departmentName:{key:"所属科室"},
    study:{key:"学习情况"},
    sex:{key:"性别"},
    birthDate:{key:"出生年月", changeDate:true},
    phone:{key:"手机号码"},
    levelOfEducation:{key:"文化程度"},
    askForTime:{key:"申请入党时间", changeDate:true},
    listedAsActivistsTime:{key:"列为积极分子", changeDate:true},
    liaison:{key:"联系人"},
    administrativePositionName:{key:"行政职务"},
    color:{key:"颜色"},
}


/**
 * 使用端:   小程序_党员入口
 * 场景:     预备党员详情
 */
 export const prepareDetailsConfig = {
    etId:{key:"名册录入类型"},
    name:{key:"姓名"},
    partyPositionsName:{key:"党内职务"},
    departmentName:{key:"所属科室"},
    study:{key:"学习情况"},
    sex:{key:"性别"},
    birthDate:{key:"出生年月", changeDate:true},
    phone:{key:"手机号码"},
    levelOfEducation:{key:"文化程度"},
    branchName:{key:"所属支部"},
    askForTime:{key:"申请入党时间", changeDate:true},
    talkTime:{key:"谈话时间", changeDate:true},
    administrativePositionName:{key:"行政职务"},
    color:{key:"颜色"},
}


/**
 * 使用端:   小程序_党员入口
 * 场景:     党费管理
 */
export const partyExpensesConfig = {
    pmId:{key:"pmId"},
    payType:{key:"缴纳状态"},
    payTime:{key:"缴费时间", changeDate:true},
    name:{key:"姓名"},
    partyPositionsName:{key:"党内职务"},
    departmentName:{key:"所属科室"},
    partyJoiningTime:{key:"入党时间", changeDate:true},
}


/**
 * 使用端:   小程序_党员入口
 * 场景:     党费管理
 */
export const expensesMenberConfig = {
    name:{key:"姓名"},
    partyPositionsName:{key:"党内职务"},
    departmentName:{key:"所属科室"},
    partyJoiningTime:{key:"入党时间", changeDate:true},
}


/**
 * 使用端:   小程序_党员入口
 * 场景:  党建先锋   
 */
export const partyVanguardConfig = {
    pvId:{key:"pvId"},
    honorName:{key:"荣誉名称"},
    honorType:{key:"荣誉类型"},
    grantingRange:{key:"授予范围"},
    grantingUnit:{key:"授予单位"},
    grantTime:{key:"授予时间", changeDate:true},
    img:{key:"图片地址"},
    content:{key:"内容内容"},
}


/**
 * 使用端:   小程序_党员入口
 * 场景:  组织生活  
 */
export const organlzationalLifeConfig = {
    oId:{key:"oId"},
    theme:{key:"活动标题"},
    themeType:{key:"活动类型"},
    dataMonth:{key:"活动月份", changeDate:true }
}


/**
 * 使用端:   小程序_党员入口
 * 场景:  党建资讯
 */
 export const thematicActivitiesConfig = {
    taId:{key:"pbId"},
    theme:{key:"活动名称"},
    dataMonth:{key:"数据月份", changeDate:true},
    pbType:{key:"资讯类型"},
}


/**
 * 使用端:   小程序_党员入口
 * 场景:  党建动态  
 */
export const partyBuildingDynamicConfig = {
    pbId:{key:"pbId"},
    theme:{key:"活动名称"},
    dataMonth:{key:"数据月份", changeDate:true},
    pbType:{key:"资讯类型"},
}


/**
 * 使用端:   小程序_党员入口
 * 场景:  本月积分排名  
 */
 export const learningPowerConfig = {
    pmId:{key:"党员id"},
    name:{key:"党员名称"},
    bId:{key:"支部名称"},
    dayIntegral:{key:"积分"},
    dataTime:{key:"数据时间"}
}







