
export enum ERRORENUM {
    身份验证失败 = 1,
    非法登录,
    身份验证过期,
    参数错误,
    地址数据不完整,
    请完善信息,
    该方法仅可进行数据操作,
    数据操作失败,
    数据查询失败,
    数据联合查询失败,
    该方法仅可进行查询操作,
    该方法仅可进行联合查询操作,
    分页请设置当前页数,
    密码错误,
    用户不存在,
    该用户不是管理员,
    目标用户不是正式党员,
    管理员不可被删除,
    权限不足,
    目标数据不存在,
    账号不存在,
    密码不一致,
    密码只能由6至18位字符和数字组成,
    未找到数据,
    库中不存在对应数据,
    表单校验失败,
    暂无对应数据,
    该进度不是文字学习
}

export enum ERRORCODEENUM {
    身份验证失败 = 401,
    非法登录 = 402,
    身份验证过期 = 403,
}

let bizErrorMsgMap = {};
for (let key in ERRORENUM) {
    bizErrorMsgMap[ERRORENUM[key]] = key;
}

export function getBizMsg(param) {
    return bizErrorMsgMap[param];
}