/**
 * 校验表单参数配置
 * 使用场景：  验证客户端请求参数
 *     限制：  1.使用端不同不能共用一份配置
 *             2.需要搭配 util/verificationParam -> eccFormParam() 方法使用
 *     说明:   notMustHave = true 时说明该字段是非必填的;不配该字段说明是必填的
 */


/**
 * 使用端: 小程序端_党员入口
 *   场景: 创建组织生活活动表单
 *   备注: 1.0
 */
export const CreateActivityConfig = {
    partyActivityType:{type:"Number"},//党建活动类型
    activityStartTime:{type:"Number"},//活动开始时间
    activityEndTime:{type:"Number"},//活动结束时间
    activityAdd:{type:"String", notMustHave:true},//活动地点
    activityHost:{type:"String", notMustHave:true},//活动主持人
    activityNoteTaker:{type:"String", notMustHave:true},//活动记录人
    // leavePartyMember:{type:"[String]", notMustHave:true},//请假党员
    participatingPartyMember:{type:"[String]", notMustHave:true},//参与党员
    // participationRecord:{type:"String", notMustHave:true},//活动记录
};

export const DWCreateActivityConfig = {
    partyActivityType:{type:"Number"},//党建活动类型
    activityStartTime:{type:"Number"},//活动开始时间
    activityEndTime:{type:"Number"},//活动结束时间
    activityAdd:{type:"String", notMustHave:true},//活动地点
    activityHost:{type:"String", notMustHave:true},//活动主持人
    activityNoteTaker:{type:"String", notMustHave:true},//活动记录人
    // leavePartyMember:{type:"[String]", notMustHave:true},//请假党员
    participatingPartyMember:{type:"[String]", notMustHave:true},//参与党员
    // participationRecord:{type:"String", notMustHave:true},//活动记录
};



export const UpdateActivityConfig = {
    partyActivityType:{type:"Number"},//党建活动类型
    activityStartTime:{type:"Number"},//活动开始时间
    activityEndTime:{type:"Number"},//活动结束时间
    activityAdd:{type:"String", notMustHave:true},//活动地点
    activityHost:{type:"String", notMustHave:true},//活动主持人
    activityNoteTaker:{type:"String", notMustHave:true},//活动记录人
    leavePartyMember:{type:"[String]", notMustHave:true},//请假党员
    signedInMember:{type:"[String]", notMustHave:true},//签到人员
    log:{type:"String", notMustHave:true},//活动记录
    participatingPartyMember:{type:"[String]", notMustHave:true},//参与党员
    // participationRecord:{type:"String", notMustHave:true},//活动记录
};


/**
 * 正式党员
 */
export const CreateZSDYConfig = {
    name:{type:"String", notMustHave:true},//姓名
    sex:{type:"Number", notMustHave:true},//性别 1男2女
    birthDate:{type:"Number", notMustHave:true},//性别 1男2女
    phone:{type:"String", notMustHave:true},//手机号码
    levelOfEducation:{type:"Number", notMustHave:true},//文化程度
    partyJoiningTime:{type:"Number", notMustHave:true},//入党时间
    administrativePositionName:{type:"Number", notMustHave:true},//行政职务id
    partyPositionsName:{type:"[Number]", notMustHave:true},//党内职务id
    desc:{type:"String", notMustHave:true},//备注
}




/**
 * 预备党员
 */
export const CreateYBDYConfig = {
    name:{type:"String", notMustHave:true},//姓名
    sex:{type:"Number", notMustHave:true},//性别 1男2女
    birthDate:{type:"Number", notMustHave:true},//性别 1男2女
    phone:{type:"String", notMustHave:true},//手机号码
    levelOfEducation:{type:"Number", notMustHave:true},//文化程度
    askForTime:{type:"Number", notMustHave:true},//申请入党时间
    yubeiTime:{type:"Number", notMustHave:true},//预备党员时间
    administrativePositionName:{type:"Number", notMustHave:true},//行政职务id
    desc:{type:"String", notMustHave:true},//备注
}





/**
 * 发展对象
 */
export const CreateFZDXConfig = {
    name:{type:"String", notMustHave:true},//姓名
    sex:{type:"Number", notMustHave:true},//性别 1男2女
    birthDate:{type:"Number", notMustHave:true},//性别 1男2女
    phone:{type:"String", notMustHave:true},//手机号码
    levelOfEducation:{type:"Number", notMustHave:true},//文化程度
    askForTime:{type:"Number", notMustHave:true},//申请入党时间
    fzdxTime:{type:"Number", notMustHave:true},//发展对象时间
    administrativePositionName:{type:"Number", notMustHave:true},//行政职务id
    desc:{type:"String", notMustHave:true},//备注
}




/**
 * 入党积极分子
 */
export const CreateRDJJFZConfig = {
    name:{type:"String", notMustHave:true},//姓名
    sex:{type:"Number", notMustHave:true},//性别 1男2女
    birthDate:{type:"Number", notMustHave:true},//性别 1男2女
    phone:{type:"String", notMustHave:true},//手机号码
    levelOfEducation:{type:"Number", notMustHave:true},//文化程度
    askForTime:{type:"Number", notMustHave:true},//申请入党时间
    listedAsActivistsTime:{type:"Number", notMustHave:true},//列为积极分子时间
    administrativePositionName:{type:"Number", notMustHave:true},//行政职务id
    desc:{type:"String", notMustHave:true},//备注
}


/**
 * 入党申请
 */
export const CreateRDSQConfig = {
    name:{type:"String", notMustHave:true},//姓名
    sex:{type:"Number", notMustHave:true},//性别 1男2女
    birthDate:{type:"Number", notMustHave:true},//性别 1男2女
    phone:{type:"String", notMustHave:true},//手机号码
    levelOfEducation:{type:"Number", notMustHave:true},//文化程度
    askForTime:{type:"Number", notMustHave:true},//申请入党时间
    talkTime:{type:"Number", notMustHave:true},//谈话时间
    administrativePositionName:{type:"Number", notMustHave:true},//行政职务id
    desc:{type:"String", notMustHave:true},//备注
}


/**
 * 支部制度
 */
export const CreateZBZDConfig = {
    title:{type:"String", notMustHave:true},//制度标题
    releaseTime:{type:"Number", notMustHave:true},//发布时间
    periodTime:{type:"Number", notMustHave:true},//有效期
    content:{type:"String", notMustHave:true},//内容
}



/**
 * 党委支部制度
 */
export const CreateDWZBZDConfig = {
    bId:{type:"[Number]"},//生效支部
    title:{type:"String", notMustHave:true},//制度标题
    releaseTime:{type:"Number", notMustHave:true},//发布时间
    periodTime:{type:"Number", notMustHave:true},//有效期
    content:{type:"String", notMustHave:true},//内容
}




export const CreateDJXFConfig = {
    honorName:{type:"String"},//  "荣誉名称1",
    honorType:{type:"Number"},//  "区级",
    grantingRange:{type:"Number", },//  "团体",
    grantingUnit:{type:"[String]"},//  "上海市*****单位",
    grantTime:{type:"Number"},//  "2023-08-30"
    content:{type:"String"},//  "内容"
    img:{type:"String"},//  "图片
}


