/**
 * 党员入口登录
 */

import { ERRORENUM } from '../config/errorEnum';
import { BizError } from '../util/bizError';
import * as sysTools from "../tools/system";
import { operationalData, selectData } from '../middleware/databaseSuccess';
import { OPERATIONALDATATYPE, TABLENAME } from '../config/dbEnum';
import { PARTYPOSITIONS } from '../config/enum';
const moment = require("moment");


function checkLeader(partyPositionsNames) {
    for (let i = 0; i < partyPositionsNames.length; i++) {
        if (partyPositionsNames[i] >= PARTYPOSITIONS.支部书记) return true;
    }
    return false
}

function checkDWLeader(partyPositionsNames) {
    for (let i = 0; i < partyPositionsNames.length; i++) {
        if (partyPositionsNames[i] >= PARTYPOSITIONS.党总支书记 && partyPositionsNames[i] <= PARTYPOSITIONS.党总支纪检委员) return true;
    }
    return false
}

export async function login(loginId:string, pwd:string) {
    let clomun = ["pmId", "loginId", "pwd", "token", "bId", "administrativePositionName", "partyPositionsName", "firstChangeLogin"];
    let loginInfo:any = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.党员基础信息表, {loginId}, clomun);
    if (!loginInfo) throw new BizError(ERRORENUM.账号不存在, `${loginId}账号非党员账号`);
    
    let check = sysTools.getPwdMd5(loginId, pwd);

    if (loginInfo.pwd != check) throw new BizError(ERRORENUM.密码错误);

    const Token = sysTools.getToken(loginId);

    let updateLogin = {
        token: Token,
        tokenMs: moment(new Date()).format("YYYY-MM-DD HH:mm:ss")
    }

    await operationalData(OPERATIONALDATATYPE.修改, TABLENAME.党员基础信息表, updateLogin, {loginId});

    let userType = checkLeader(JSON.parse(loginInfo.partyPositionsName) ) ? 2 : 1;

    if (checkDWLeader(JSON.parse(loginInfo.partyPositionsName)) ) userType = 3;
    
    return {
        userid: loginInfo.pmId,
        token: Token,
        name:loginInfo.name,
        bId: loginInfo.bId,
        userType,
        firstChangeLogin:loginInfo.firstChangeLogin != 1
    };
}


/**
 * 修改密码
 * 未使用
 * @param uscc 信用代码
 * @param pwd 原密码  md5之后的
 * @param newPwd 新密码  未md5
 * @param confirmPwd 确认新密码  未md5
 * @returns {isSuccess:true}
 */
export async function changePassword(userId:string, pwd:string, newPwd:string, confirmPwd:string ) {
    if (newPwd != confirmPwd) throw new BizError(ERRORENUM.密码不一致);

    let partyMemberInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.党员基础信息表, {pmId:userId}, ["pmId", "loginId", "pwd"]);
    if (!partyMemberInfo) throw new BizError(ERRORENUM.未找到数据);

    /**由于pwd是md5之后的 所以这里md5一次即可 */
    let checkPwd = sysTools.getPwdMd5(partyMemberInfo.loginId, pwd);
    if (partyMemberInfo.pwd != checkPwd) throw new BizError(ERRORENUM.密码错误);


    /**由于pwd是md5之后的 所以这里md5一次即可 */
    let newCheckPwd = sysTools.getPwdMd5(partyMemberInfo.loginId, newPwd );

    /**考虑到如果前端把新密码也md5 就不可以验证是不是符合规则 所以前端传的是明文
     * 我们初始化密码的时候 有两次加密 第一次是密码md5 然后再和loginId 进行md5
     * 于是这里也要如此操作
     */
    partyMemberInfo.pwd = checkPwd;
    await operationalData(OPERATIONALDATATYPE.修改, TABLENAME.党员基础信息表, {pwd:newCheckPwd}, {pmId:userId});

    return {isSuccess:true};
}


export async function firstChangePwd(userId, newPwd, confirmation) {
    if (newPwd != confirmation) throw new BizError(ERRORENUM.密码不一致);

    let partyMemberInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.党员基础信息表, {pmId:userId}, ["pmId", "loginId", "pwd"]);
    if (!partyMemberInfo) throw new BizError(ERRORENUM.未找到数据);

    let checkPwd = sysTools.getPwdMd5(partyMemberInfo.loginId,  newPwd);

    await operationalData(OPERATIONALDATATYPE.修改, TABLENAME.党员基础信息表, {pwd:checkPwd, firstChangeLogin:1}, {pmId:userId});

    return {isSuccess:true};
}






