/**
 * 党建先锋
 */

import { OPERATIONALDATATYPE, TABLENAME } from "../config/dbEnum";
import { operationalData, selectData } from "../middleware/databaseSuccess";
import { extractData } from "../util/piecemeal";
import * as splitResultConfig from "../config/splitResultConfig";
import * as configEnum from "../config/enum";
import * as verificationEnumTools from "../util/verificationEnum";
import moment = require("moment");
import { eccFormParam } from "../util/verificationParam";
import { CreateDJXFConfig } from "../config/eccFormParamConfig";
import { BizError } from "../util/bizError";
import { ERRORENUM } from "../config/errorEnum";

/**
 * 获取党建先锋列表
 * @param bId 弃用支部id，数据表删除该字段
 * @param honorName 
 * @returns 
 */
export async function partyVanguardList(bId:number, honorName:string) {
    
    let param:any = {};
    if (honorName) param.honorName = honorName;
    let clomun = ["pvId", "honorName", "honorType", "grantingRange", "grantingUnit", "grantTime", "img", "content" ];

    let partyVanguardData = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.党建先锋表, param, clomun);
    
    let allUserList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.党员基础信息表, {bId}, ["name", "pmId"])

    let allUserMap = {};
    allUserList.forEach(info => {
        allUserMap[info.pmId] = info.name;
    });

    let dataList = [];
    partyVanguardData.forEach( info => {
        let changeData:any = extractData(splitResultConfig.partyVanguardConfig, info);
        let grantingUnitStr = "";
       
        if (info.grantingRange == configEnum.GRANTINGRANGE.个人) {
            changeData.honorType = verificationEnumTools.changeEnumValue(configEnum.PERSONHONORTYPE, info.honorType);
            JSON.parse(info.grantingUnit).forEach(str => {
                grantingUnitStr += `,${allUserMap[str]}`;
            });
        } else {
            changeData.honorType = verificationEnumTools.changeEnumValue(configEnum.HONORTYPE, info.honorType);
            JSON.parse(info.grantingUnit).forEach(str => {
                grantingUnitStr += `,${str}`;
            });
        }
        
        changeData.grantingRange = verificationEnumTools.changeEnumValue(configEnum.GRANTINGRANGE, info.grantingRange);
        changeData.grantTime = moment(info.grantTime).format("YYYY-MM-DD");
        changeData.content = info.content;
        changeData.img = info.img;

        

        changeData.grantingUnit = grantingUnitStr.replace(",", "");

        dataList.push(changeData);
    });

    return {dataList};
}


/**
 * 获取党建先锋荣誉详情
 * @param pvId 
 * @returns 
 */
export async function partyVanguardDetsils(pvId:number) {
    let param = {pvId};
    let clomun = ["pvId", "honorName", "honorType", "grantingRange", "grantingUnit", "grantTime", "img", "content" ];
    let partyVanguardData = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.党建先锋表, param, clomun);
    if (!partyVanguardData || !partyVanguardData.pvId) throw new BizError(ERRORENUM.目标数据不存在);

    let dataInfo:any = extractData(splitResultConfig.partyVanguardConfig, partyVanguardData);
    dataInfo.honorType = verificationEnumTools.changeEnumValue(configEnum.HONORTYPE, partyVanguardData.honorType);
    dataInfo.grantingRange = verificationEnumTools.changeEnumValue(configEnum.GRANTINGRANGE, partyVanguardData.grantingRange);
    dataInfo.grantTime = moment(partyVanguardData.grantTime).format("YYYY-MM-DD");
    dataInfo.content = partyVanguardData.content;
    dataInfo.img = partyVanguardData.img;

    let grantingUnitStr = "";
    partyVanguardData.grantingUnit.forEach(str => {
        grantingUnitStr += `,${str}`;
    });

    dataInfo.grantingUnit = grantingUnitStr.replace(",", "");

    return { dataInfo }
}


export async function addPartyVanguard(bId, param) {
    const FuncName = "添加先锋";
    eccFormParam(FuncName, CreateDJXFConfig, param);
    verificationEnumTools.eccEnumValue(FuncName, "honorType", configEnum.HONORTYPE, param.honorType);
    verificationEnumTools.eccEnumValue(FuncName, "grantingRange", configEnum.GRANTINGRANGE, param.grantingRange);

    let addInfo = {
        honorName:param.honorName,//  "荣誉名称1",
        honorType:param.honorType,//  "区级",
        grantingRange:param.grantingRange,//  "团体",
        grantingUnit:JSON.stringify(param.grantingUnit),//  "上海市*****单位",
        grantTime:new Date(param.grantTime),//  "2023-08-30"
        content:param.content,//  "内容"
        img:param.img,//  "图片
        bId
    };

    await operationalData(OPERATIONALDATATYPE.增加, TABLENAME.党建先锋表, addInfo, {});

    return {isSuccess:true}
}
