/**
 * 党建质量指数
 */

import * as configEnum from "../config/enum";
import { selectData } from "../middleware/databaseSuccess";
import { OPERATIONALDATATYPE, TABLENAME } from "../config/dbEnum";
import * as verificationEnumTools from "../util/verificationEnum";
import moment = require("moment");


/**
 * 党建质量指数列表
 * @param bId 支部id
 * @returns [{"dataList":{"key":"一级指标名称","list":{"totalScore":0,"completionProgress":}}}]
 */
export async function partyQualityList(bId:number) {
    let dataYear = moment(new Date().valueOf()).format("YYYY");
    let selectParam = {bId:{"%like%": bId}};
    let clomun = ["tlId", "primaryIndicators", "secondaryIndicators", "thirdLevelContent", "thirdLevelScore", "currentScore", "completionProgress"];
    let partyQualityData = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.党建质量三级指标, selectParam, clomun);
    
    let partyQualityList = [];
    for (let key in configEnum.PRIMARYINDICATORS) {
        let primaryIndicatorsData = {};
        let anyKey:any = key;
        if (isNaN(anyKey)) {
            const EnumValue = parseInt(configEnum.PRIMARYINDICATORS[key])
            primaryIndicatorsData["dataList"] = {key: anyKey, value:EnumValue,  list: []};
            primaryIndicatorsData["detail"] = {};

            partyQualityData.forEach( info => {
                let schedule = "进行中";
                let {tlId, primaryIndicators, secondaryIndicators, thirdLevelContent, thirdLevelScore, currentScore, completionProgress} = info; //一级指标、总分、三级指标得分、完成进度
                if (completionProgress == 100) schedule = "已完成"
                if (primaryIndicators == EnumValue) {
                    primaryIndicatorsData["dataList"]["list"].push({
                        primaryIndicators,
                        thirdLevelScore,
                        currentScore,
                        completionProgress,
                        schedule
                    });

                    let secondary = verificationEnumTools.changeEnumValue(configEnum.SECONDARYINDICATORS, secondaryIndicators);
                    if(!primaryIndicatorsData["detail"][secondary]) primaryIndicatorsData["detail"][secondary] = {schedule, dataList: []};
                    if (thirdLevelScore != currentScore) primaryIndicatorsData["detail"][secondary]["schedule"] = "进行中";
                    primaryIndicatorsData["detail"][secondary]["dataList"].push({
                        thirdLevelContent,
                        thirdLevelScore,
                    });

                }
            })
            partyQualityList.push(primaryIndicatorsData);
        }
    }

    let partyQuality = [];
    partyQualityList.forEach( item => {
        let {dataList} = item;
        let {key, value, list} = dataList;
        let count = list.length;

        let changeDataInfo:any = {};
        let changeData:any = {totalScore:0, completionProgress:0, currentScore:0};
        list.forEach( info => {
            let {thirdLevelScore, currentScore, completionProgress, schedule} = info;
            changeData.schedule = schedule;
            changeData.totalScore += thirdLevelScore;
            changeData.completionProgress += completionProgress;
            changeData.currentScore += currentScore;
        })

        let completion = changeData.completionProgress/count;
        if (completion == 100) changeData.schedule = "已完成";
        changeData.completionProgress = Math.round(completion);

        changeDataInfo.key = key;
        changeDataInfo.value = value;
        changeDataInfo.dataInfo = changeData;

        partyQuality.push(changeDataInfo);

    })

    return {dataList:partyQuality};
}




export async function partyQualityInfo(bId:number, qualityId:number) {
    
    verificationEnumTools.eccEnumValue("获取详情", "qualityId", configEnum.PRIMARYINDICATORS, qualityId);

    let dataYear = moment(new Date().valueOf()).format("YYYY");
    let selectParam = {bId:{"%like%": bId}, primaryIndicators:qualityId};
    let clomun = ["tlId", "primaryIndicators", "secondaryIndicators", "thirdLevelContent", "thirdLevelScore", "currentScore", "completionProgress"];
    let partyQualityData = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.党建质量三级指标, selectParam, clomun);
    
    let dataMap = {};
    partyQualityData.forEach(info => {
        if (!dataMap[info.secondaryIndicators]) dataMap[info.secondaryIndicators] = {state:1, content:info.thirdLevelContent};
        else {
            dataMap[info.secondaryIndicators].content += "<br>";
            dataMap[info.secondaryIndicators].content += info.thirdLevelContent;
        }

        if (info.completionProgress < 100) dataMap[info.secondaryIndicators].state = 0;
    });

    let dataList = [];
    for (let key in dataMap) {
        let title = verificationEnumTools.changeEnumValue(configEnum.SECONDARYINDICATORS, parseInt(key));
        dataList.push({
            title,
            content:dataMap[key].content,
            schedule:dataMap[key].state == 1 ? "已完成" : "进行中"
        });
    }

    return {dataList};
}









