/**
 * 党费管理
 */

import * as configEnum from "../config/enum";
import { selectData, selectManyTableData } from "../middleware/databaseSuccess";
import { OPERATIONALDATATYPE, TABLENAME } from "../config/dbEnum";
import moment = require("moment");
import { changeEnumValue } from "../util/verificationEnum";


/**
 * 获取党费管理数据
 * @param bId 支部id
 * @param name 党员名称
 * @param payType 缴纳状态
 * @param payableYear 缴纳时间-年份
 * @param payableMonth 缴纳时间-月份
 * @returns 基础数据："baseData": {"partyCount":党员总数, "paid":已缴纳人数, "unpaid":未缴纳人数}
 * @returns 党费列表："partyExpensesList": [{"name":"党员名称","payType":"缴纳状态","pmId":"党员id","payTime":"缴纳时间","partyPositionsName":"党内职务","departmentName":"所属科室","partyJoiningTime":"党龄"}, ......]
 */
 export async function partyExpensesData(bId, payType, payableYear, payableMonth) {
    let param:any = { bId, payableYear, payableMonth };
    // if (payType) param.payType = payType;

    let manyTableConfig = {};
    manyTableConfig[TABLENAME.党员基础信息表] = {column:["name", "etId", "partyPositionsName", "partyJoiningTime", "departmentName"], where:{etId:1} };
    let partyExpensesList = await selectManyTableData(OPERATIONALDATATYPE.多表联查, TABLENAME.党费管理表, param, ["peId", "payType", "payAmount"], manyTableConfig);
    
    let dataList = [];
    let allAmount = 0;
    let completed = 0;
    let incomplete = 0;
    partyExpensesList.forEach(info => {
        let {partyMember, payAmount} = info;

        let item = {
            name:partyMember.name,
            partyPositionsName:"党员",//党员类型
            payType:changeEnumValue(configEnum.PAYTYPE, info.payType),//状态
            partyJoiningTime:moment(partyMember.partyJoiningTime).format("YYYY-MM-DD"),
            departmentName:changeEnumValue(configEnum.DEDPARTMENT , partyMember.departmentName),
            payAmount:payAmount
        };
        if (payType && info.payType == payType) {
            dataList.push(item);
        } else {
            dataList.push(item);
        }
       
        if (info.payType == configEnum.PAYTYPE.已缴纳) {
            allAmount += payAmount;
            completed += 1;
        } else {
            allAmount += payAmount;
            incomplete += 1;
        }
    });

    let rate = 0;
    if ( (completed + incomplete) ) {
        rate = Math.round(completed/(completed + incomplete)*100)
    }

    return {statisInfo:{rate, allAmount, completed, incomplete }, dataList};
}


/**
 * 
 */
export async function selfPartyExpensesData(userid, payType) {
    let param = {pmId:userid};
    let partyExpensesList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.党费管理表, param, ["peId", "payType", "payAmount", "payableMonth"]);

    let userInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.党员基础信息表, param, ["partyJoiningTime"]);

    let dataList = [];
    let payCount = 0;
    partyExpensesList.forEach(info => {
        if (payType == info.payType) {
            dataList.push({
                month:info.payableMonth+'月',
                payAmount:info.payAmount+'元',
                payType:changeEnumValue(configEnum.PAYTYPE, info.payType)
            });
        }

        if (info.payType == configEnum.PAYTYPE.已缴纳) {
            payCount += info.payAmount;
        }
        
    })

    let activityCount = await selectData(OPERATIONALDATATYPE.查询数据量, TABLENAME.组织生活表, {signedInMember:{"%like%":userid } }, [] );

    let partyStanding = "-年";
    if (partyStanding) partyStanding = Math.floor(moment().diff(userInfo.partyJoiningTime, 'years'))+'年';
    return {dataList, statis:{payCount, activityCount, partyStanding}};
}















