/**
 * 党建资讯 partyBuildingDynamic
 */

import { OPERATIONALDATATYPE, TABLENAME } from "../config/dbEnum";
import { selectData } from "../middleware/databaseSuccess";
import moment = require("moment");
import { ACTIVITIESTYPE } from "../config/enum";
import { changeEnumValue } from "../util/verificationEnum";


/**
 * 获取党建资讯列表
 * @param bId 
 * @param theme 主题
 * @param activityYear 年份
 * @param activityMonth 月份
 * @returns partyBuildingDynamicList:[{"pbId":1, "theme":"党建动态主题", "dataMonth":"数据月份"}, ......]
 */
export async function partyBuildingDynamicList(bId:number, activitiesType:Number) {

    let param:any = {
        bId,
        activitiesType:{"%like%":activitiesType}
    };

    let partyInformationList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.专题活动表, param, ["taId", "theme", "activitiesType","activitesTime"]);
    let dataList = [];
    partyInformationList.forEach(info => {

        let activitiesTypeList = [];
        JSON.parse(info.activitiesType).forEach(itemKey => {
            activitiesTypeList.push({
                title:changeEnumValue(ACTIVITIESTYPE, itemKey),
                color:"red"
            });
        })

        dataList.push({
            taId:info.taId,
            activitiesType:activitiesTypeList,
            theme:info.theme,
            activitesTime:moment(info.activitesTime).format("YYYY-MM-DD")
        });
    });

    return {dataList};
}


/**
 * 获取党建资讯详情
 * @param pbId 
 * @returns partyBuildingDynamicInfo:{ "theme":"党建动态主题", "dataMonth":"数据月份", "fileName":["党建动态文件名称", ......] }
 */
export async function partyBuildingDynamicDetsils(taId:number) {

    let files = ["taId", "activitiesType", "theme", "content", "activitesTime"];
    let partyInformation = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.专题活动表, {taId}, files);

    let activitiesTypeList = [];
    JSON.parse(partyInformation.activitiesType).forEach(itemKey => {
        activitiesTypeList.push({
            title:changeEnumValue(ACTIVITIESTYPE, itemKey),
            color:"red"
        });
    })
    let dataInfo:any = {};
    dataInfo.taId = partyInformation.taId;
    dataInfo.theme = partyInformation.theme;
    dataInfo.content = partyInformation.content;
    dataInfo.activitesTime = moment(partyInformation.activitesTime).format("YYYY-MM-DD");
    dataInfo.source = "牙防所党建";
    dataInfo.activitiesType = activitiesTypeList;

    return {dataInfo};
}
 

/**
 * 获取党建动态详情
 * @param pbId 
 * @returns partyBuildingDynamicInfo:{ "theme":"党建动态主题", "dataMonth":"数据月份", "fileName":["党建动态文件名称", ......] }
 */
export async function dynamicsDetails(pbId:number) {

    let files = ["pbId", "img", "theme", "content", "activitesTime"];
    let partyInformation = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.党建动态表, {pbId}, files);

    let dataInfo:any = {};
    dataInfo.pbId = partyInformation.taId;
    dataInfo.theme = partyInformation.theme;
    dataInfo.content = partyInformation.content;
    dataInfo.activitesTime = moment(partyInformation.activitesTime).format("YYYY-MM-DD");
    dataInfo.source = "牙防所党建";
    dataInfo.img = partyInformation.img || "http://172.16.3.239:40004/yfs/files/4/default.png";

    return {dataInfo};
}
 












