import { changeEnumValue } from "../util/verificationEnum";
import * as configEnum from "../config/enum";
import * as clientConfigEnum from "../config/clientEnum";
import { extractData } from "../util/piecemeal";
import * as splitResultConfig from "../config/splitResultConfig";
import { operationalData, selectData, selectManyTableData } from "../middleware/databaseSuccess";
import { OPERATIONALDATATYPE, TABLENAME } from "../config/dbEnum";
import moment = require("moment");
import * as verificationEnumTools from "../util/verificationEnum";
import { getStudent } from "./partyMember";
import { getRandomId, md5PwdStr } from "../tools/system";
import { eccFormParam } from "../util/verificationParam";
import { CreateActivityConfig, CreateDJXFConfig, CreateDWZBZDConfig, CreateFZDXConfig, CreateRDJJFZConfig, CreateRDSQConfig, CreateYBDYConfig, CreateZBZDConfig, CreateZSDYConfig, DWCreateActivityConfig } from "../config/eccFormParamConfig";
import { ERRORENUM } from "../config/errorEnum";
import { BizError } from "../util/bizError";

const ColorConfig = {
    1:"#C62A23",
    2:"#E4B386",
    3:"#2aa115",//发展对象
    4:"#3549B0",
    5:"#1e5eff"
};

function changePartyPositionsName(partyPositionsName, etId) {
    let str = "";
    for (let i= 0; i < partyPositionsName.length; i++) {
        let item = partyPositionsName[i];
        if (item < 10) continue;
        str += `,${verificationEnumTools.changeEnumValue(configEnum.PARTYPOSITIONS, item)}`;
    }
    if (!str) {
        let partyPositionsNameStr = "";
        if (etId == configEnum.ENTRYTYPE.正式党员) partyPositionsNameStr = "党员";
        else partyPositionsNameStr = verificationEnumTools.changeEnumValue(configEnum.ENTRYTYPE, etId);
        return {partyPositionsNameStr, color:ColorConfig[etId]};
    }

    return {partyPositionsNameStr : str.replace(",", ""), color:"#C62A23"};
}


export async function homeData() {
    let branch = "牙防所党委" //支部名称

    let param = { };
    let partyQualityScore = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.党建质量三级指标, param, ["thirdLevelScore", "currentScore"]);
    
    let scoreCount = 0;//得分
    let massSum = 0;//总分
    partyQualityScore.forEach( score => {
        massSum += score.thirdLevelScore;
        scoreCount += score.currentScore;
    });

    let branchCount = 4;

    let partyNoticeParam = {};
    let partyNoticeList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.党建通知, partyNoticeParam, ["title", "content", "dataTime"]);

    let noticeList = [];
    partyNoticeList.forEach(info => {
        noticeList.push({
            title:info.title,//类型
            content:info.content,//内容
            time:moment(info.dataTime).format("YYYY-MM-DD")
        });
    });
    
    return { branch, branchCount, scoreCount, noticeList, noticeCount:noticeList.length };
}




export async function activitiesData() {
    let param = { };

    /**资讯 = 活动表 */
    let partyInformationList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.专题活动表, param, ["taId", "theme", "activitesTime"]);
    let dataList = [];
    partyInformationList.forEach( info => {
        let changeData:any = extractData(splitResultConfig.partyInformationConfig, info);
        changeData.time = moment(info.activitesTime).format('YYYY-MM-DD');
        changeData.dateMs = new Date(info.activitesTime).valueOf();
        changeData.pbType = configEnum.PBTYPE.党建资讯;
        changeData.labels = ["专题活动"];
        changeData.id = info.taId;
        dataList.push(changeData);
    });
    dataList.sort( (a, b) => { return b.dateMs - a.dateMs; });


    /**动态 */
    let partyBuildingDynamicDataList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.党建动态表, param, ["pbId", "theme", "dataMonth", "fileName"]);
    let dynamicsList = [];
    partyBuildingDynamicDataList.forEach(info => {
        let addInfo = {
            theme : info.theme,
            id : info.pbId,
            fileUrl:info.fileName[0] || ""
        }
        dynamicsList.push(addInfo);
    });

    return {dynamicsList, informationList:dataList}
}


export async function partymemberList() {
    let param = {};

    let dbList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.党员基础信息表, param, [ "bId"]);

    let map = {};
    let allCount = 0;

    dbList.forEach(info => {
        let {bId} = info;
        if (!map[bId]) map[bId] = {count:0, name:changeEnumValue(configEnum.BRANCHNAMESTR, bId), bId}
        map[bId].count += 1;

        allCount += 1;
    });

    let dataList = [{name:"牙防所党建总人数", count:allCount, bId:0}];

    for (let key in map) {
        dataList.push(map[key])
    }

    return {dataList};
}

export async function partymemberTypeList(bId) {
    let param:any = {};
    if (bId) param.bId = bId;

    let dbList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.党员基础信息表, param, ["etId", "bId"]);

    let map = {};

    dbList.forEach(info => {
        let {etId} = info;
        if (!map[etId]) map[etId] = {count:0, name:changeEnumValue(configEnum.ENTRYTYPE, etId), memberType:etId, bId}
        map[etId].count += 1;
    });

    let dataList = [];

    for (let key in map) {
        dataList.push(map[key])
    }

    return {dataList};
}





export async function partymemberSublist(bId:number, name:string, duration:number, memberType:number, departmentName:number  ) {
    let param:any = {}
    if(bId) param.bId = {"%like%": bId};
    if (memberType) param.etId = {"%like%": memberType};
    if (name) param["name"] = {"%like%":name};
    let clomun = ["pmId", "name", "etId", "partyPositionsName", "partyJoiningTime", "departmentName"];
    let partyMemberList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.党员基础信息表, param, clomun);

    let nameList = [];
    /**截取返回字段 */
    partyMemberList.forEach( info => {
        let changeData:any = extractData(splitResultConfig.partyMemberConfig, info);

        let {color, partyPositionsNameStr} = changePartyPositionsName( JSON.parse(info.partyPositionsName), changeData.etId);
        changeData.partyPositionsName = partyPositionsNameStr;
        changeData.color = color;

        let time = moment(new Date()).format("YYYY");
        let partyJoiningTime = time;
        if (info.partyJoiningTime) partyJoiningTime = moment(info.partyJoiningTime).format("YYYY")
        changeData.partyStanding = parseInt(time) - parseInt(partyJoiningTime) + "年";

        changeData.branchName = changeEnumValue(configEnum.BRANCHNAMESTR, info.bId);

        let departmentName = JSON.parse(changeData.departmentName);
        changeData.departmentName = verificationEnumTools.changeEnumValue(configEnum.DEDPARTMENT, departmentName);

        nameList.push(changeData);
    })

    return {nameList};
}



/**
 * 添加党员信息
 * @param memberType 
 * @param param 
 * @returns 
 */
export async function addMember(bId, memberType:number, param) {
    let addInfo:any = {
        pmId:getRandomId("member"),
        bId,
        etId:memberType,
        isAdmin:0,
        loginId:param.phone,
    };//添加参数

    for (let key in param) {
        addInfo[key] = param[key];
    }

    const FuncName = "添加党员";
    switch (memberType) {
        case configEnum.ENTRYTYPE.正式党员:
            eccFormParam(FuncName, CreateZSDYConfig, param);
            addInfo.partyJoiningTime =moment(param.partyJoiningTime).format("YYYY-MM-DD");
            param.partyPositionsName.forEach(itemId => {
                verificationEnumTools.eccEnumValue(FuncName, "partyPositionsName", configEnum.PARTYPOSITIONS, itemId);
            });
            addInfo.partyPositionsName = JSON.stringify(param.partyPositionsName);
        break;
        case configEnum.ENTRYTYPE.入党申请:
            eccFormParam(FuncName, CreateRDSQConfig, param);
            addInfo.askForTime = moment(param.askForTime).format("YYYY-MM-DD");
            addInfo.talkTime = moment(param.talkTime).format("YYYY-MM-DD");
        break;
        case configEnum.ENTRYTYPE.入党积极分子:
            eccFormParam(FuncName, CreateRDJJFZConfig, param);
            addInfo.askForTime = moment(param.askForTime).format("YYYY-MM-DD");
            addInfo.listedAsActivistsTime = moment(param.listedAsActivistsTime).format("YYYY-MM-DD");
        break;
        case configEnum.ENTRYTYPE.发展对象:
            eccFormParam(FuncName, CreateFZDXConfig, param);
            addInfo.askForTime = moment(param.askForTime).format("YYYY-MM-DD");
            addInfo.fzdxTime = moment(param.fzdxTime).format("YYYY-MM-DD");
        break;
        case configEnum.ENTRYTYPE.预备党员:
            eccFormParam(FuncName, CreateYBDYConfig, param);
            addInfo.askForTime = moment(param.askForTime).format("YYYY-MM-DD");
            addInfo.yubeiTime = moment(param.yubeiTime).format("YYYY-MM-DD");
        break;
    }

    verificationEnumTools.eccEnumValue(FuncName, "sex", configEnum.SEX, param.sex);
    verificationEnumTools.eccEnumValue(FuncName, "levelOfEducation", configEnum.DEGREE, param.levelOfEducation);
    verificationEnumTools.eccEnumValue(FuncName, "administrativePositionName", configEnum.ADMINISTRATIVEPOSITION, param.administrativePositionName);

    addInfo.birthDate = moment(param.birthDate).format("YYYY-MM-DD");

    addInfo.pwd = md5PwdStr(param.phone.slice(param.phone.length-6));

    await operationalData(OPERATIONALDATATYPE.增加, TABLENAME.党员基础信息表, addInfo, {});

    return {isSuccess:true};
}


export async function partyNoticeList() {
    let partyNoticeParam = {};
    let partyNoticeList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.党建通知, partyNoticeParam, []);

    let dataList = [];
    partyNoticeList.forEach(info => {
        dataList.push({
            title:info.title,
            content:info.content,
            time:moment(info.dataTime).format("YYYY-MM-DD")
        });
    });
    
    return { dataList };
}



export async function partyexpensesList(payableYear, payableMonth) {
  let param:any = { payableYear, payableMonth };
  
    let manyTableConfig = {};
    manyTableConfig[TABLENAME.党员基础信息表] = {column:["name", "etId", "bId",  "partyPositionsName", "partyJoiningTime", "departmentName"], where:{etId:1} };
    let partyExpensesList = await selectManyTableData(OPERATIONALDATATYPE.多表联查, TABLENAME.党费管理表, param, ["peId", "payType", "payAmount"], manyTableConfig);
    
    let allAmount = 0;
    let completed = 0;
    let incomplete = 0;
    let map = {};

    partyExpensesList.forEach(info => {
        let {partyMember, payAmount, payType} = info;

        if (!map[partyMember.bId]) map[partyMember.bId] = {name:changeEnumValue(configEnum.BRANCHNAMESTR, partyMember.bId), bId:partyMember.bId, allCount:0, payCount:0};
        map[partyMember.bId].allCount += 1;

        
        if (info.payType == configEnum.PAYTYPE.已缴纳) {
            allAmount += payAmount;
            completed += 1;
            map[partyMember.bId].payCount += 1;
        } else {
            allAmount += payAmount;
            incomplete += 1;
        }
    });

    let rate = 0;
    if ( (completed + incomplete) ) {
        rate = Math.round(completed/(completed + incomplete)*100)
    }

    let dataList = [];
    for (let key in map) {
        let info = map[key];
        let itemRate = 0;
        if ( info.allCount && info.payCount ) {
            itemRate = Math.round(info.payCount/info.allCount *100)
        }

        dataList.push({name:info.name, rate:itemRate, count:info.allCount, bId:info.bId});
    }

  
    return {statisInfo:{rate, allAmount, completed, incomplete }, dataList};
}


export async function partyexpensesBranchList(bId, payType, payableYear, payableMonth) {
    let param:any = { bId, payableYear, payableMonth };
    // if (payType) param.payType = payType;

    let manyTableConfig = {};
    manyTableConfig[TABLENAME.党员基础信息表] = {column:["name", "etId", "partyPositionsName", "partyJoiningTime", "departmentName"], where:{etId:1} };
    let partyExpensesList = await selectManyTableData(OPERATIONALDATATYPE.多表联查, TABLENAME.党费管理表, param, ["peId", "payType", "payAmount"], manyTableConfig);
    
    let dataList = [];
    let allAmount = 0;
    let completed = 0;
    let incomplete = 0;
    partyExpensesList.forEach(info => {
        let {partyMember, payAmount} = info;

        let item = {
            name:partyMember.name,
            partyPositionsName:"党员",//党员类型
            payType:changeEnumValue(configEnum.PAYTYPE, info.payType),//状态
            partyJoiningTime:moment(partyMember.partyJoiningTime).format("YYYY-MM-DD"),
            departmentName:changeEnumValue(configEnum.DEDPARTMENT , partyMember.departmentName),
            payAmount:payAmount
        };
        if (payType && info.payType == payType) {
            dataList.push(item);
        } else {
            dataList.push(item);
        }
       
        if (info.payType == configEnum.PAYTYPE.已缴纳) {
            allAmount += payAmount;
            completed += 1;
        } else {
            allAmount += payAmount;
            incomplete += 1;
        }
    });

    let rate = 0;
    if ( (completed + incomplete) ) {
        rate = Math.round(completed/(completed + incomplete)*100)
    }

    return {statisInfo:{rate, allAmount, completed, incomplete }, dataList};
}




export async function partyexpensesMemberList(payType:number, bId, name:string, duration:number, departmentName:number) {
    let param:any = {payType};
    if (bId) param.bId = {"%like%": bId};
    // if (duration) param.duration = duration;
    if (departmentName) param.departmentName = departmentName;
    // if (name) param.name = name;
    // if (payType) param.payType = payType;

    let manyTableConfig = {};
    manyTableConfig[TABLENAME.党员基础信息表] = {column:["name", "etId", "partyPositionsName", "partyJoiningTime", "departmentName"], where:{etId:1} };
    let partyExpensesList = await selectManyTableData(OPERATIONALDATATYPE.多表联查, TABLENAME.党费管理表, param, ["peId", "payType", "payAmount"], manyTableConfig);
    
    let dataList = [];
    partyExpensesList.forEach(info => {
        let {partyMember, payAmount} = info;

        let item = {
            name:partyMember.name,
            partyPositionsName:"党员",//党员类型
            payType:changeEnumValue(configEnum.PAYTYPE, info.payType),//状态
            partyJoiningTime:moment(partyMember.partyJoiningTime).format("YYYY-MM-DD"),
            departmentName:changeEnumValue(configEnum.DEDPARTMENT , JSON.parse(partyMember.departmentName)),
            payAmount:payAmount
        };
        dataList.push(item)
    });
    return {dataList};
}



/**
 * 支部制度列表
 * @param bId 支部id
 * @param systemTitle 制度主题 可模糊查询 
 * @returns branchSystemList:[{"bsId":1, "systemTitle":"制度标题"}, ......]
 */
export async function branchSystemList(systemTitle:string) {
    let param = { };
    if(systemTitle) param["systemTitle"] = {"%like%": systemTitle};

    let branchSystemList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.支部制度表, param, ["bsId", "systemTitle", "releaseTime"]);
    branchSystemList = branchSystemList || [];
    let dataList = [];
    branchSystemList.forEach(info => {
        dataList.push({
            bsId:info.bsId,
            title:info.systemTitle,
            time:moment(info.releaseTime).format("YYYY-MM-DD")
        });
    });

    return {dataList};
}



/**
 * 添加制度细则
 * @param bsId 支部制度id 
 * @returns 
 */
export async function addOneBranchSystemDetsils( param) {
  
    eccFormParam("添加制度细则", CreateDWZBZDConfig, param);

    let addInfo = {
        systemTitle:param.title,
        releaseTime:moment(param.releaseTime).format("YYYY-MM-DD"),
        periodTime:moment(param.periodTime).format("YYYY-MM-DD"),
        content:param.content,
        bId:JSON.stringify(param.bId)
    };
    await operationalData(OPERATIONALDATATYPE.增加, TABLENAME.支部制度表, addInfo, {});
    

    return {isSuccess:true};
}




/**
 * 获取组织生活列表
 * @param bId 支部id
 * @param theme 活动名称 模糊查询
 * @param themeType 活动类型
 * @param dataMonth 活动月份
 * @returns organizationalLifeList[{"oId":1, "theme":"活动主题", "themeType":"活动类型", "dataMonth":"活动月份"}]
 */
export async function organizationalLifeList( theme:string, themeType:number) {
    let param = { };
    if (theme) param["theme"] = {"%like%": theme};
    if (themeType) param["partyActivityType"] = themeType;

    let clomun = ["oId", "activityStartTime", "activityEndTime", "activityAdd", "partyActivityType"];
    let organizationalLifeDataList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.组织生活表, param, clomun);

    const Now = new Date().valueOf();
    let dataList = [];
    organizationalLifeDataList.forEach(info => {
        let st = new Date(info.activityStartTime).valueOf();
        let et = new Date(info.activityEndTime).valueOf();
        let state = "";
        if (st < Now && et > Now) state = "正在进行";
        else if (Now > et) state = "已结束";
        else state = "即将开展";

        let sTimeStr = moment(info.activityStartTime).format("YYYY-MM-DD HH:mm");
        let time = `${sTimeStr}-${moment(info.activityEndTime).format("HH:mm")}`;

        dataList.push({
            oId:info.oId,
            address:info.activityAdd,
            time,
            state,
            theme:verificationEnumTools.changeEnumValue(configEnum.THEMETYPE, info.partyActivityType)
        });
    });

    return {dataList};
}


export async function addOrg( param) {
    const FuncName = "添加组织生活";
    eccFormParam(FuncName, DWCreateActivityConfig, param);
    verificationEnumTools.eccEnumValue(FuncName, "partyActivityType", configEnum.THEMETYPE, param.partyActivityType );

    let leavePartyMember = [];
    if (param.leavePartyMember) leavePartyMember = [param.leavePartyMember];

    let addInfo = {
        partyActivityType:param.partyActivityType,
        activityStartTime:moment(param.activityStartTime).format("YYYY-MM-DD HH:mm:SS"),
        activityEndTime:moment(param.activityEndTime).format("YYYY-MM-DD HH:mm:SS"),
        activityAdd:param.activityAdd,
        activityHost:param.activityHost,
        activityNoteTaker:param.activityNoteTaker,
        leavePartyMember:JSON.stringify(leavePartyMember),
        participatingPartyMember:JSON.stringify(param.participatingPartyMember || []),
    };
    await operationalData(OPERATIONALDATATYPE.增加, TABLENAME.组织生活表, addInfo, {});

    return {isSuccess:true}
}

//====================


/**
 * 获取党建先锋列表
 * @param bId 弃用支部id，数据表删除该字段
 * @param honorName 
 * @returns 
 */
export async function dwPartyVanguardList(honorName:string) {
    
    let param:any = {};
    if (honorName) param.honorName = honorName;
    let clomun = ["pvId", "honorName", "honorType", "grantingRange", "grantingUnit", "grantTime", "img", "content" ];

    let partyVanguardData = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.党建先锋表, param, clomun);
    
    let allUserList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.党员基础信息表, {}, ["name", "pmId"])

    let allUserMap = {};
    allUserList.forEach(info => {
        allUserMap[info.pmId] = info.name;
    });

    let dataList = [];
    partyVanguardData.forEach( info => {
        let changeData:any = extractData(splitResultConfig.partyVanguardConfig, info);
        let grantingUnitStr = "";
       
        if (info.grantingRange == configEnum.GRANTINGRANGE.个人) {
            changeData.honorType = verificationEnumTools.changeEnumValue(configEnum.PERSONHONORTYPE, info.honorType);
            JSON.parse(info.grantingUnit).forEach(str => {
                grantingUnitStr += `,${allUserMap[str]}`;
            });
        } else {
            changeData.honorType = verificationEnumTools.changeEnumValue(configEnum.HONORTYPE, info.honorType);
            JSON.parse(info.grantingUnit).forEach(str => {
                grantingUnitStr += `,${str}`;
            });
        }
        
        changeData.grantingRange = verificationEnumTools.changeEnumValue(configEnum.GRANTINGRANGE, info.grantingRange);
        changeData.grantTime = moment(info.grantTime).format("YYYY-MM-DD");
        changeData.content = info.content;
        changeData.img = info.img;

        

        changeData.grantingUnit = grantingUnitStr.replace(",", "");

        dataList.push(changeData);
    });

    return {dataList};
}


/**
 * 获取党建先锋荣誉详情
 * @param pvId 
 * @returns 
 */
export async function dwPartyVanguardDetsils(pvId:number) {
    let param = {pvId};
    let clomun = ["pvId", "honorName", "honorType", "grantingRange", "grantingUnit", "grantTime", "img", "content" ];
    let partyVanguardData = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.党建先锋表, param, clomun);
    if (!partyVanguardData || !partyVanguardData.pvId) throw new BizError(ERRORENUM.目标数据不存在);

    let dataInfo:any = extractData(splitResultConfig.partyVanguardConfig, partyVanguardData);
    dataInfo.honorType = verificationEnumTools.changeEnumValue(configEnum.HONORTYPE, partyVanguardData.honorType);
    dataInfo.grantingRange = verificationEnumTools.changeEnumValue(configEnum.GRANTINGRANGE, partyVanguardData.grantingRange);
    dataInfo.grantTime = moment(partyVanguardData.grantTime).format("YYYY-MM-DD");
    dataInfo.content = partyVanguardData.content;
    dataInfo.img = partyVanguardData.img;

    let grantingUnitStr = "";
    partyVanguardData.grantingUnit.forEach(str => {
        grantingUnitStr += `,${str}`;
    });

    dataInfo.grantingUnit = grantingUnitStr.replace(",", "");

    return { dataInfo }
}


export async function addDWPartyVanguard(bId, param) {
    const FuncName = "添加先锋";
    eccFormParam(FuncName, CreateDJXFConfig, param);
    verificationEnumTools.eccEnumValue(FuncName, "honorType", configEnum.HONORTYPE, param.honorType);
    verificationEnumTools.eccEnumValue(FuncName, "grantingRange", configEnum.GRANTINGRANGE, param.grantingRange);

    let addInfo = {
        honorName:param.honorName,//  "荣誉名称1",
        honorType:param.honorType,//  "区级",
        grantingRange:param.grantingRange,//  "团体",
        grantingUnit:JSON.stringify(param.grantingUnit),//  "上海市*****单位",
        grantTime:new Date(param.grantTime),//  "2023-08-30"
        content:param.content,//  "内容"
        img:param.img,//  "图片
        bId
    };

    await operationalData(OPERATIONALDATATYPE.增加, TABLENAME.党建先锋表, addInfo, {});

    return {isSuccess:true}
}


/**
 * 获取党建资讯列表
 * @param bId 
 * @param theme 主题
 * @param activityYear 年份
 * @param activityMonth 月份
 * @returns partyBuildingDynamicList:[{"pbId":1, "theme":"党建动态主题", "dataMonth":"数据月份"}, ......]
 */
export async function partyBuildingDynamicList( activitiesType:Number) {

    let param:any = {
        activitiesType:{"%like%":activitiesType}
    };

    let partyInformationList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.专题活动表, param, ["taId", "theme", "activitiesType","activitesTime"]);
    let dataList = [];
    partyInformationList.forEach(info => {

        let activitiesTypeList = [];
        JSON.parse(info.activitiesType).forEach(itemKey => {
            activitiesTypeList.push({
                title:changeEnumValue(configEnum.ACTIVITIESTYPE, itemKey),
                color:"red"
            });
        })

        dataList.push({
            taId:info.taId,
            activitiesType:activitiesTypeList,
            theme:info.theme,
            activitesTime:moment(info.activitesTime).format("YYYY-MM-DD")
        });
    });

    return {dataList};
}


/**
 * 获取党建资讯详情
 * @param pbId 
 * @returns partyBuildingDynamicInfo:{ "theme":"党建动态主题", "dataMonth":"数据月份", "fileName":["党建动态文件名称", ......] }
 */
export async function partyBuildingDynamicDetsils(taId:number) {

    let files = ["taId", "activitiesType", "theme", "content", "activitesTime"];
    let partyInformation = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.专题活动表, {taId}, files);

    let activitiesTypeList = [];
    JSON.parse(partyInformation.activitiesType).forEach(itemKey => {
        activitiesTypeList.push({
            title:changeEnumValue(configEnum.ACTIVITIESTYPE, itemKey),
            color:"red"
        });
    })
    let dataInfo:any = {};
    dataInfo.taId = partyInformation.taId;
    dataInfo.theme = partyInformation.theme;
    dataInfo.content = partyInformation.content;
    dataInfo.activitesTime = moment(partyInformation.activitesTime).format("YYYY-MM-DD");
    dataInfo.source = "牙防所党建";
    dataInfo.activitiesType = activitiesTypeList;

    return {dataInfo};
}



/**
 * 党建质量指数列表
 * @param bId 支部id
 * @returns [{"dataList":{"key":"一级指标名称","list":{"totalScore":0,"completionProgress":}}}]
 */
export async function partyQualityList() {
    let dataYear = moment(new Date().valueOf()).format("YYYY");
    let selectParam = {};
    let clomun = ["tlId", "primaryIndicators", "secondaryIndicators", "thirdLevelContent", "thirdLevelScore", "currentScore", "completionProgress"];
    let partyQualityData = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.党建质量三级指标, selectParam, clomun);
    
    let partyQualityList = [];
    for (let key in configEnum.PRIMARYINDICATORS) {
        let primaryIndicatorsData = {};
        let anyKey:any = key;
        if (isNaN(anyKey)) {
            const EnumValue = parseInt(configEnum.PRIMARYINDICATORS[key])
            primaryIndicatorsData["dataList"] = {key: anyKey, value:EnumValue,  list: []};
            primaryIndicatorsData["detail"] = {};

            partyQualityData.forEach( info => {
                let schedule = "进行中";
                let {tlId, primaryIndicators, secondaryIndicators, thirdLevelContent, thirdLevelScore, currentScore, completionProgress} = info; //一级指标、总分、三级指标得分、完成进度
                if (completionProgress == 100) schedule = "已完成"
                if (primaryIndicators == EnumValue) {
                    primaryIndicatorsData["dataList"]["list"].push({
                        primaryIndicators,
                        thirdLevelScore,
                        currentScore,
                        completionProgress,
                        schedule
                    });

                    let secondary = verificationEnumTools.changeEnumValue(configEnum.SECONDARYINDICATORS, secondaryIndicators);
                    if(!primaryIndicatorsData["detail"][secondary]) primaryIndicatorsData["detail"][secondary] = {schedule, dataList: []};
                    if (thirdLevelScore != currentScore) primaryIndicatorsData["detail"][secondary]["schedule"] = "进行中";
                    primaryIndicatorsData["detail"][secondary]["dataList"].push({
                        thirdLevelContent,
                        thirdLevelScore,
                    });

                }
            })
            partyQualityList.push(primaryIndicatorsData);
        }
    }

    let partyQuality = [];
    partyQualityList.forEach( item => {
        let {dataList} = item;
        let {key, value, list} = dataList;
        let count = list.length;

        let changeDataInfo:any = {};
        let changeData:any = {totalScore:0, completionProgress:0, currentScore:0};
        list.forEach( info => {
            let {thirdLevelScore, currentScore, completionProgress, schedule} = info;
            changeData.schedule = schedule;
            changeData.totalScore += thirdLevelScore;
            changeData.completionProgress += completionProgress;
            changeData.currentScore += currentScore;
        })

        let completion = changeData.completionProgress/count;
        if (completion == 100) changeData.schedule = "已完成";
        changeData.completionProgress = Math.round(completion);

        changeDataInfo.key = key;
        changeDataInfo.value = value;
        changeDataInfo.dataInfo = changeData;

        partyQuality.push(changeDataInfo);

    })

    return {dataList:partyQuality};
}


export async function partyQualityInfo( qualityId:number) {
    
    verificationEnumTools.eccEnumValue("获取详情", "qualityId", configEnum.PRIMARYINDICATORS, qualityId);

    let dataYear = moment(new Date().valueOf()).format("YYYY");
    let selectParam = {primaryIndicators:qualityId};
    let clomun = ["tlId", "primaryIndicators", "secondaryIndicators", "thirdLevelContent", "thirdLevelScore", "currentScore", "completionProgress"];
    let partyQualityData = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.党建质量三级指标, selectParam, clomun);
    
    let dataMap = {};
    partyQualityData.forEach(info => {
        if (!dataMap[info.secondaryIndicators]) dataMap[info.secondaryIndicators] = {state:1, content:info.thirdLevelContent};
        else {
            dataMap[info.secondaryIndicators].content += "<br>";
            dataMap[info.secondaryIndicators].content += info.thirdLevelContent;
        }

        if (info.completionProgress < 100) dataMap[info.secondaryIndicators].state = 0;
    });

    let dataList = [];
    for (let key in dataMap) {
        let title = verificationEnumTools.changeEnumValue(configEnum.SECONDARYINDICATORS, parseInt(key));
        dataList.push({
            title,
            content:dataMap[key].content,
            schedule:dataMap[key].state == 1 ? "已完成" : "进行中"
        });
    }

    return {dataList};
}
