
/**
 * 初始化数据库
 */

import { OPERATIONALDATATYPE, TABLENAME } from "../config/dbEnum";
import { operationalData, selectData } from "../middleware/databaseSuccess";
import { getPwdMd5, md5PwdStr } from "../tools/system";

export async function dataInit() {
    await dataInit2();
    return 
    let list = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.党员基础信息表, {bId:1, etId:1}, ["pmId"]);

    for (let i= 0; i < list.length; i++) {
        let info = list[i];
        let itemList = [];
        for (let j = 1; j <= 6; j++) {
            let item = {
                pmId:info.pmId,
                bId:1, 
                payType:2,
                payableMonth:j,
                payableYear:2025,
                payAmount:100
            };
            itemList.push(item);
        }
        
        await operationalData(OPERATIONALDATATYPE.增加, TABLENAME.党费管理表, itemList, {})
    }
    
}


export async function dataInit2() {
    console.log("18234720432  =>", getPwdMd5("18234720432", md5PwdStr("18234720432")));
    console.log("15007949519  =>", getPwdMd5("15007949519", md5PwdStr("15007949519")));
    console.log("17638538121  =>", getPwdMd5("17638538121", md5PwdStr("17638538121")));
    console.log("15201707076  =>", getPwdMd5("15201707076", md5PwdStr("15201707076")));
    
}