/**
 * 支部制度
 */

import moment = require("moment");
import { OPERATIONALDATATYPE, TABLENAME } from "../config/dbEnum";
import { UPTYPE } from "../config/enum";
import { ERRORENUM } from "../config/errorEnum";
import { systemConfig } from "../config/systemConfig";
import { operationalData, selectData } from "../middleware/databaseSuccess";
import { getFileUrl } from "../middleware/getUrl";
import { BizError } from "../util/bizError";
import { eccFormParam } from "../util/verificationParam";
import { CreateZBZDConfig } from "../config/eccFormParamConfig";
import { getBindId } from "../tools/system";


/**
 * 支部制度列表
 * @param bId 支部id
 * @param systemTitle 制度主题 可模糊查询 
 * @returns branchSystemList:[{"bsId":1, "systemTitle":"制度标题"}, ......]
 */
export async function branchSystemList(bId:number, systemTitle:string) {
    let param = { bId:{"%like%": bId} };
    if(systemTitle) param["systemTitle"] = {"%like%": systemTitle};

    let branchSystemList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.支部制度表, param, ["bsId", "systemTitle", "releaseTime"]);
    branchSystemList = branchSystemList || [];
    let dataList = [];
    branchSystemList.forEach(info => {
        dataList.push({
            bsId:info.bsId,
            title:info.systemTitle,
            time:moment(info.releaseTime).format("YYYY-MM-DD")
        });
    });

    return {dataList};
}


/**
 * 制度细则
 * @param bsId 支部制度id 
 * @returns branchSystemInfo:{"bsId":1, "systemTitle":"制度标题", "fileName":["制度文件1", ......]}
 */
export async function branchSystemDetsils(bsId:number) {
    let clomun = ["bsId", "systemTitle", "content", "periodTime", "releaseTime"];
    let branchSystemInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.支部制度表, {bsId}, clomun);
    if(!branchSystemInfo || !branchSystemInfo.bsId)  throw new BizError(ERRORENUM.库中不存在对应数据, `制度细则中不存在id=${bsId}的数据`);
    // let fileNameList = getFileUrl(branchSystemInfo.fileName, token, UPTYPE.支部制度, userid);
    // branchSystemInfo.fileName = fileNameList;

    let dataInfo = {
        title:branchSystemInfo.systemTitle,
        releaseTime:moment(branchSystemInfo.releaseTime).format("YYYY-MM-DD"),
        content:branchSystemInfo.content,
        source:"牙防所党建"
    };

    return {dataInfo};
}


/**
 * 添加制度细则
 * @param bsId 支部制度id 
 * @returns 
 */
export async function addOneBranchSystemDetsils(bId:number, param) {
  
    eccFormParam("添加制度细则", CreateZBZDConfig, param);

    let addInfo = {
        systemTitle:param.title,
        releaseTime:moment(param.releaseTime).format("YYYY-MM-DD"),
        periodTime:moment(param.periodTime).format("YYYY-MM-DD"),
        content:param.content,
        bId:JSON.stringify([bId])
    };
    await operationalData(OPERATIONALDATATYPE.增加, TABLENAME.支部制度表, addInfo, {});

    return {isSuccess:true};
}



