/**
 * 首页基础数据
 */

import { changeEnumValue } from "../util/verificationEnum";
import * as configEnum from "../config/enum";
import * as clientConfigEnum from "../config/clientEnum";
import { extractData } from "../util/piecemeal";
import * as splitResultConfig from "../config/splitResultConfig";
import { selectData } from "../middleware/databaseSuccess";
import { OPERATIONALDATATYPE, TABLENAME } from "../config/dbEnum";
import moment = require("moment");
import * as verificationEnumTools from "../util/verificationEnum";
import { getStudent } from "./partyMember";

/**
 * 主页基础数据
 * @param bId 支部id
 * @returns 支部名称：branch:"牙防所第一支部"
 * @returns 党员总数：partyMemberNum:0 
 * @returns 党建质量总数：massSum:0 
 * @returns 党建质量指数：massIndex:0 
 * @returns 党内职务人员列表：partyPositions:[{"key":"支部书记", "list":["张三","李四"]}, {"key":"支部副书记", "list":["暂无数据"]}, ......] 
 */
 export async function homeData(bId:number) {
    let branch = changeEnumValue(configEnum.BRANCHNAME, bId); //支部名称

    let param = { bId };
    let partyQualityScore = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.党建质量三级指标, param, ["thirdLevelScore", "currentScore"]);
    
    let scoreCount = 0;//得分
    let massSum = 0;//总分
    partyQualityScore.forEach( score => {
        massSum += score.thirdLevelScore;
        scoreCount += score.currentScore;
    });

    let selectAllColumn = ["bId", "partyPositionsName", "name"];
    let allMemberList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.党员基础信息表, param, selectAllColumn);
    let partyMemberNum = allMemberList.length;//本支部人员总数

    let partyNoticeParam = {bId};
    let partyNoticeList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.党建通知, partyNoticeParam, ["title", "content", "dataTime"]);

    let noticeList = [];
    partyNoticeList.forEach(info => {
        noticeList.push({
            title:info.title,//类型
            content:info.content,//内容
            time:moment(info.dataTime).format("YYYY-MM-DD")
        });
    });
    
    // let partyPositionsMap = {}; // = []; //党内职务人员 [{key, list:["", ""]}]
    // for (let key in clientConfigEnum.PARTYPOSITIONS) {
    //     let anyKey:any = key;
    //     if (isNaN(anyKey)) { //枚举key  key = string
    //         partyPositionsMap[anyKey] = {key:anyKey, list:[]}
    //     }
    // }
    // allMemberList.forEach(item => {
    //     let { partyPositionsName, name} = item;
    //     const ItemBId = item.bId;
    //     if (ItemBId == bId) {
    //         partyMemberNum += 1;
    //         let partyPositionsList = getPartyPositionsList(JSON.parse(partyPositionsName));
    //         partyPositionsList.forEach(positions => {
    //             partyPositionsMap[positions].list.push(name);
    //         });
    //     }
    // });
    // let partyPositions = []; //党内职务人员 [{key, list:["", ""]}]
    // for (let key in partyPositionsMap ) {
    //     let dataItem = partyPositionsMap[key];
    //     if (!dataItem.list.length) dataItem.list.push("暂无数据");
    //     partyPositions.push(dataItem)
    // }

    return { branch, partyMemberNum, scoreCount, noticeList, noticeCount:noticeList.length };
}


/**
 * 职务人员数组数据转换
 * @param numberList [100,101]
 * @returns strList:["支部书记", "支部副书记" ]
 */
function getPartyPositionsList(numberList) {
    let strList = [];
    numberList.forEach(enumNum => {
        let value = changeEnumValue(clientConfigEnum.PARTYPOSITIONS, enumNum);
        if (value) strList.push(value);
    });
    return strList;
}


/**
 * 查询党建资讯列表
 * @param bId 支部id
 * @returns 资讯列表：dataList:[返回字段参考splitResultConfig文件中的partyInformamtionConfig配置]
 */
 export async function activitiesData(bId:number) {
    let param = { bId };

    /**资讯 = 活动表 */
    let partyInformationList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.专题活动表, param, ["taId", "theme", "activitesTime", "activitiesType"]);
    let dataList = [];
    partyInformationList.forEach( info => {
        let changeData:any = extractData(splitResultConfig.partyInformationConfig, info);
        
        let activitiesType = [];
        JSON.parse(info.activitiesType).forEach(item => {
            activitiesType.push(changeEnumValue( configEnum.ACTIVITIESTYPE, item));
        });
        
        changeData.time = moment(info.activitesTime).format('YYYY-MM-DD');
        changeData.dateMs = new Date(info.activitesTime).valueOf();
        changeData.pbType = configEnum.PBTYPE.党建资讯;
        changeData.labels = activitiesType;
        changeData.id = info.taId;
        dataList.push(changeData);
    });
    dataList.sort( (a, b) => { return b.dateMs - a.dateMs; });


    /**动态 */
    let partyBuildingDynamicDataList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.党建动态表, param, ["pbId", "theme", "dataMonth", "fileName", "img"]);
    let dynamicsList = [];
    partyBuildingDynamicDataList.forEach (info => {
        let addInfo = {
            theme : info.theme,
            id : info.pbId,
            // fileUrl:info.fileName[0] || "",
            img:info.img,
            content:info.content
        }

        dynamicsList.push(addInfo);
    });

    return {dynamicsList:dynamicsList, informationList:dataList};
}


const ColorConfig = {
    1:"#C62A23",
    2:"#E4B386",
    3:"#2aa115",//发展对象
    4:"#3549B0",
    5:"#1e5eff"
};

function changePartyPositionsName(partyPositionsName, etId) {
    let str = "";
    for (let i= 0; i < partyPositionsName.length; i++) {
        let item = partyPositionsName[i];
        if (item < 10) continue;
        str += `,${verificationEnumTools.changeEnumValue(configEnum.PARTYPOSITIONS, item)}`;
    }
    if (!str) {
        let partyPositionsNameStr = "";
        if (etId == configEnum.ENTRYTYPE.正式党员) partyPositionsNameStr = "党员";
        else partyPositionsNameStr = verificationEnumTools.changeEnumValue(configEnum.ENTRYTYPE, etId);
        return {partyPositionsNameStr, color:ColorConfig[etId]};
    }

    return {partyPositionsNameStr : str.replace(",", ""), color:"#C62A23"};
}


/**
 * 个人首页  上面 和 中部
 * @param pmId 
 * @param bId 
 * @returns 
 */
export async function memberHomeData(pmId:string, bId:number) {
    let clomun = ["bId", "pmId", "etId", "name", "sex", "birthDate", "phone", "levelOfEducation", "bId", "partyPositionsName", "partyJoiningTime", "administrativePositionName", 
    "departmentName", "askForTime", "listedAsActivistsTime", "liaison", "talkTime", "partyState"];
    let partyMemberInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.党员基础信息表, {pmId}, clomun);
    let changeData:any = extractData(splitResultConfig.partyMemberConfig, partyMemberInfo);

    let {color, partyPositionsNameStr} = changePartyPositionsName( JSON.parse(partyMemberInfo.partyPositionsName), changeData.etId);
    changeData.color = color;
    changeData.partyPositionsName = partyPositionsNameStr;
    
    changeData.departmentName = verificationEnumTools.changeEnumValue(configEnum.DEDPARTMENT, JSON.parse(partyMemberInfo.departmentName));
    changeData.sex = verificationEnumTools.changeEnumValue(configEnum.SEX, partyMemberInfo.sex);
    changeData.administrativePositionName = verificationEnumTools.changeEnumValue(configEnum.ADMINISTRATIVEPOSITION, partyMemberInfo.administrativePositionName);
    changeData.partyState = verificationEnumTools.changeEnumValue(configEnum.PARTYSTATE, partyMemberInfo.partyState);
    changeData.levelOfEducation = verificationEnumTools.changeEnumValue(configEnum.DEGREE, partyMemberInfo.levelOfEducation);

    changeData.study = await getStudent(bId, pmId); //学习相关数据

    let time = moment(new Date()).format("YYYY");
    let partyJoiningTime = time;
    if (changeData.partyJoiningTime) partyJoiningTime = moment(partyMemberInfo.partyJoiningTime).format("YYYY")
    changeData.partyStanding = parseInt(time) - parseInt(partyJoiningTime) + "年";

    if (partyMemberInfo.partyJoiningTime) {
        changeData.partyStanding = Math.floor(moment().diff(partyMemberInfo.partyJoiningTime, 'years'))+'年';
        changeData.partyJoiningTime = moment(partyMemberInfo.partyJoiningTime).format("YYYY年MM月DD日");
    } else {
        changeData.partyStanding = "-年";
        changeData.partyJoiningTime = "-";
    }
    
    changeData.position = "-";
    changeData.branch = changeEnumValue(configEnum.BRANCHNAME, bId);

    let partyExpensesClomun = ["payAmount"]
    let payList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.党费管理表, {pmId, payType:configEnum.PAYTYPE.已缴纳}, partyExpensesClomun);

    let payAmountCount = 0;
    payList.forEach(info => {
        let {payAmount} = info;
        payAmountCount += payAmount;
    });

    let activityCount = await selectData(OPERATIONALDATATYPE.查询数据量, TABLENAME.组织生活表, {signedInMember:{"%like%":pmId } }, [] );

    let middleInfo = {
        payAmountCount,
        activityCount,
        offlineCount:0,
        online:0
    };


    return {baseInfo:changeData, middleInfo};
}


/**
 * 个人首页  底部
 * @param pmId 
 * @param bId 
 */
export async function memberHomeBottomData( bId:number, activitiesType:number) {
    let files = ["theme", "activitesTime", "taId", "img", "bId"];
    let thematicActivitiesList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.专题活动表, {bId, activitiesType:{"%like%":activitiesType}}, files );
    let dataList = [];
    thematicActivitiesList.forEach(info => {
        let { taId, theme, activitesTime, img } = info;
        dataList.push({
            taId,
            theme,
            activitesTime:moment(activitesTime).format("YYYY-MM-DD"),
            img:img || "",
            source:changeEnumValue(configEnum.BRANCHNAME, bId)
        });
    });

    return {dataList};
}

















