/**
 * admin
 */

import moment = require("moment");
import { OPERATIONALDATATYPE, TABLENAME } from "../config/dbEnum";
import { ERRORENUM } from "../config/errorEnum";
import { operationalData, selectData } from "../middleware/databaseSuccess";
import { getPwdMd5, getTimeKey, getToken } from "../tools/system";
import { BizError } from "../util/bizError";
import { BRANCHNAMESTR, DEGREE, ENTRYTYPE, PARTYPOSITIONS, SEX } from "../config/enum";
import { changeEnumValue } from "../util/verificationEnum";

export async function login(loginId:string, pwd:string) {
    let clomun = ["pmId", "loginId", "pwd", "token", "bId", "administrativePositionName", "partyPositionsName", "firstChangeLogin"];
    let loginInfo:any = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.党员基础信息表, {loginId}, clomun);
    if (!loginInfo) throw new BizError(ERRORENUM.账号不存在, `${loginId}账号非党员账号`);
    
    let check = getPwdMd5(loginId, pwd);

    if (loginInfo.pwd != check) throw new BizError(ERRORENUM.密码错误);

    const Token = getToken(loginId);

    let updateLogin = {
        adminToken: Token,
        adminTokenMs: moment(new Date()).format("YYYY-MM-DD HH:mm:ss")
    }

    await operationalData(OPERATIONALDATATYPE.修改, TABLENAME.党员基础信息表, updateLogin, {loginId});
    
    return {
        userid: loginInfo.pmId,
        token: Token,
        name:loginInfo.name
    };
}


export async function logOut(userId) {
    let clomun = ["pmId", "loginId", "pwd", "token", "bId", "administrativePositionName", "partyPositionsName", "firstChangeLogin"];
    let loginInfo:any = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.党员基础信息表, {pmId:userId}, clomun);
    if (!loginInfo) throw new BizError(ERRORENUM.账号不存在, `${userId}账号非党员账号`);
    

    let updateLogin = {
        adminToken: "",
        adminTokenMs: moment(new Date()).format("YYYY-MM-DD HH:mm:ss")
    }

    await operationalData(OPERATIONALDATATYPE.修改, TABLENAME.党员基础信息表, updateLogin, {pmId:userId});
    
    return { isSuccess:true};
}

export async function zzjgList() {
    let clomun = ["name", "partyPositionsName", "bId"];
    let dbList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.党员基础信息表, {etId:ENTRYTYPE.正式党员}, clomun);

    let map = {};
    dbList.forEach(info => {
        let {name, bId, partyPositionsName} = info;
        let partyPositionsNameList = JSON.parse(partyPositionsName);
        
        let isZZB = false;
        let zzbStrList = [];

        let subStrList = [];
        let notParty = false;

        partyPositionsNameList.forEach(item => {
            if (item < 100 && item >= 10) {
                isZZB = true;
                zzbStrList.push(changeEnumValue( PARTYPOSITIONS, item));
                notParty = true;
            }
            if (item >= 100) {
                subStrList.push(changeEnumValue( PARTYPOSITIONS, item));
                notParty = true;
            }
        })

        if (isZZB) {
            if (!map[0]) map[0] = {};
            zzbStrList.forEach(item => {
                map[0][item] = name
            });
        }
        
        if (!map[bId]) map[bId] = {subList:[]};
        subStrList.forEach(item => {
            map[bId][item] = name
        });

        if (!notParty) {
            map[bId].sublist.push(name);
        }  

    });

    let dataList = [];
    for (let key in map) {
        if (key == "0") continue;
        let item = map[key];
        item.name = changeEnumValue(BRANCHNAMESTR, parseInt(key))
        dataList.push(item);
    }

    return {zzbInfo:map[0], }
}

function changePartyPositionsName(partyPositionsName) {
    let str = "";
    if (!partyPositionsName || partyPositionsName.length) return str;

    for (let i= 0; i < partyPositionsName.length; i++) {
        let item = partyPositionsName[i];
        if (item < 10) continue;
        str += changeEnumValue( PARTYPOSITIONS, item);
    }
    if (!str) {
        str = "党员";
    }

    return str;
}

export async function dyxxList(etId:number, str:string, bId:number, startMs:number, endMs:number, page:number) {
    let param:any = {etId};

    if (str) param.name = {"%like%":str};getTimeKey
    if (bId) param.bId = bId;
    if (startMs && endMs) param.birthDate = {"%between%":[ moment(startMs).format("YYYY-MM-DD HH:mm:ss"),  moment(endMs).format("YYYY-MM-DD HH:mm:ss")]}


    let clomun = ["pmId", "bId", "name", "sex", "birthDate", "phone", "levelOfEducation", "partyJoiningTime", "administrativePositionName", "partyPositionsName",  "askForTime", "yubeiTime", "fzdxTime", "listedAsActivistsTime", "talkTime", "desc"];
    let dbList = await selectData(OPERATIONALDATATYPE.分页查询, TABLENAME.党员基础信息表, param, clomun, page);
    let dataCount = await selectData(OPERATIONALDATATYPE.查询数据量, TABLENAME.党员基础信息表, param, clomun);

    let dataList = [];
    dbList.forEach(info => {
        let item:any = {pmId:info.pmId, name:info.name, phone:info.phone, desc:info.desc };
        item.bIdName = changeEnumValue(BRANCHNAMESTR, info.bId);
        item.sex = changeEnumValue(SEX, info.sex);
        item.levelOfEducation = changeEnumValue(DEGREE, info.levelOfEducation);

        if (info.partyPositionsName) item.partyPositionsName = changePartyPositionsName(JSON.parse(info.partyPositionsName) )

        if (info.partyJoiningTime) item.partyJoiningTime = moment(info.partyJoiningTime).format("YYYY-MM-DD");
        if (info.administrativePositionName) {
            item.administrativePositionName = changeEnumValue(DEGREE, info.levelOfEducation);
        }
        if (info.askForTime) item.askForTime = moment(info.askForTime).format("YYYY-MM-DD");
        if (info.yubeiTime) item.yubeiTime = moment(info.yubeiTime).format("YYYY-MM-DD");
        if (info.fzdxTime) item.fzdxTime = moment(info.fzdxTime).format("YYYY-MM-DD");
        if (info.listedAsActivistsTime) item.listedAsActivistsTime = moment(info.listedAsActivistsTime).format("YYYY-MM-DD");
        if (info.talkTime) item.talkTime = moment(info.talkTime).format("YYYY-MM-DD");
        dataList.push(item);
    });

    return {dataCount, dataList}
}


export async function dyxx_change(type, ) {

}