/**
 * ABI_智慧党建管理分析平台——党建目标
 */

import { OPERATIONALDATATYPE, TABLENAME } from "../../config/dbEnum";
import { PRIMARYINDICATORS, SECONDARYINDICATORS } from "../../config/enum";
import { selectData } from "../../middleware/databaseSuccess";
import { changeEnumValue } from "../../util/verificationEnum";

export async function getTargetData() {
    let clomun = ["tlId", "primaryIndicators", "secondaryIndicators", "thirdLevelContent", "thirdLevelScore", "currentScore", "completionProgress"];
    let partyQualityData = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.党建质量三级指标, {}, clomun);
    
    //todo优化一下  循环方式反了，参考partyBuilding 中的getMidScreen的写法
    let partyQualityList = [];
    for (let key in PRIMARYINDICATORS) {
        let primaryIndicatorsData = {};
        let anyKey:any = key;
        if (isNaN(anyKey)) {
            const EnumValue = parseInt(PRIMARYINDICATORS[key])
            primaryIndicatorsData = {key: anyKey, list: {}};

            partyQualityData.forEach( info => {
                let {primaryIndicators, secondaryIndicators, thirdLevelContent, thirdLevelScore, currentScore, completionProgress} = info; //一级指标、总分、三级指标得分、完成进度
                if (primaryIndicators == EnumValue) {
                    let secondary = changeEnumValue(SECONDARYINDICATORS, secondaryIndicators);
                    if(!primaryIndicatorsData["list"][secondary]) primaryIndicatorsData["list"][secondary] = []
                    primaryIndicatorsData["list"][secondary].push({
                        completionProgress
                    });

                }
            })
            partyQualityList.push(primaryIndicatorsData);
        }
    }

    let partyQuality = [];
    partyQualityList.forEach( item => {
        let {key, list} = item;
        
        let secondLevel = [];
        for (let second in list) {
            let completionProgress = 0;
            list[second].forEach( completion => {
                completionProgress += completion.completionProgress;
            })
            completionProgress = completionProgress/list[second].length;
            secondLevel.push({key:second, completionProgress})
        }

        partyQuality.push({key, dataList:secondLevel});

    })

    return partyQuality;
}







