
import * as asyncHandler from 'express-async-handler'
import { addData } from '../biz/mongo/installData';
import * as selectBiz from '../biz/mongo/selectData';
import * as updateBiz from '../biz/mongo/updateData';
import * as deleteDataBiz from '../biz/mongo/deleteData';
import { checkMongoSign } from '../middleware/user';
import { eccReqParamater } from '../tools/eccParam';

export function setRouter(httpServer){
    httpServer.post('/yfs/dataserver/mongo/table/add', checkMongoSign, asyncHandler(addTableData));
    httpServer.post('/yfs/dataserver/mongo/table/delete', checkMongoSign, asyncHandler(deleteData));
    httpServer.post('/yfs/dataserver/mongo/table/update/one', checkMongoSign, asyncHandler(updateOneData));
    httpServer.post('/yfs/dataserver/mongo/table/update/many', checkMongoSign, asyncHandler(updateManyData));
    httpServer.post('/yfs/dataserver/mongo/table/find/one', checkMongoSign, asyncHandler(findOneData));
    httpServer.post('/yfs/dataserver/mongo/table/find/many', checkMongoSign, asyncHandler(findManyData));
    httpServer.post('/yfs/dataserver/mongo/table/find/manytopage', checkMongoSign, asyncHandler(findManyToPageData));
    httpServer.post('/yfs/dataserver/mongo/table/find/count', checkMongoSign, asyncHandler(findCountData));
    httpServer.post('/yfs/dataserver/mongo/table/find/aggragate', checkMongoSign, asyncHandler(findAggragateData));
}


async function addTableData(req, res) {
    let table = req.headers.table;

    let reqConf = {data: 'Object' };
    let { data } = eccReqParamater(reqConf, req.body);

    let result = await addData(table, data);
    res.success(result);
}


async function deleteData(req, res) {
    let table = req.headers.table;

    let reqConf = {data: 'Object' };
    let { data } = eccReqParamater(reqConf, req.body);

    let result = await deleteDataBiz.delData(table, data);
    res.success(result);
}


async function updateOneData(req, res) {
    let table = req.headers.table;

    let reqConf = {param:'Object', data: 'Object' };
    let { param, data } = eccReqParamater(reqConf, req.body);

    let result = await updateBiz.updateOneData(table, param, data);
    res.success(result);
}


async function updateManyData(req, res) {
    let table = req.headers.table;

    let reqConf = {param:'Object', data: 'Object' };
    let { param, data } = eccReqParamater(reqConf, req.body);

    let result = await updateBiz.updateManyData(table, param, data);
    res.success(result);
}

async function findOneData(req, res) {
    let table = req.headers.table;

    let reqConf = {param:'Object'};
    let { param } = eccReqParamater(reqConf, req.body);

    let result = await selectBiz.selectOneDataByParam(table, param);
    res.success(result);
}
async function findManyData(req, res) {
    let table = req.headers.table;

    let reqConf = {param:'Object'};
    let { param } = eccReqParamater(reqConf, req.body);

    let result = await selectBiz.selectDataListByParam(table, param);
    res.success(result);
}
async function findManyToPageData(req, res) {
    let table = req.headers.table;

    let reqConf = {param:'Object', pageNumber:'Number', pageSize:'Number'};
    let { param, pageNumber, pageSize } = eccReqParamater(reqConf, req.body, ['pageSize']);

    let result = await selectBiz.selectDataListToPageByParam(table, param, pageNumber, pageSize);
    res.success(result);
}

async function findCountData(req, res) {
    let table = req.headers.table;

    let reqConf = {param:'Object'};
    let { param } = eccReqParamater(reqConf, req.body);

    let result = await selectBiz.selectDataCountByParam(table, param);
    res.success(result);
}

async function findAggragateData(req, res) {
    let table = req.headers.table;

    let reqConf = {param:'[Object]' };
    let { param } = eccReqParamater(reqConf, req.body);

    let result = await selectBiz.aggragateParam(table, param);
    res.success(result);
}