const Sequelize =require('sequelize');


export const TablesConfig = [
    {
        tableNameCn:'支部表',
        tableName:'branch',
        schema:{
            bId: {
                type:Sequelize.INTEGER(20), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                autoIncrement:true, //允许自增
                unique:true //表示该列的值必须唯一
            },
            branchName: {type:Sequelize.STRING(100), allowNull:false}, //支部名称
        },
        association: []
    },
    {
        tableNameCn:'后台用户表',
        tableName:'adminUser', 
        schema:{
            uId:{
                type:Sequelize.STRING(100), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            loginId:{type:Sequelize.STRING(100), allowNull:false}, //登录账号
            pwd:{type:Sequelize.STRING(100), allowNull:false}, //密码
            token:{type:Sequelize.STRING(100), allowNull:true},
            tokenMs:{type:Sequelize.DATE, allowNull:true, defaultValue:Sequelize.NOW}
        },
        association: []
    },
    {
        tableNameCn:'党员基础信息表',
        tableName:'partyMember', 
        schema:{
            pmId: {
                type:Sequelize.STRING(100), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            }, 
            etId: {type:Sequelize.INTEGER, allowNull:false, defaultValue:1}, //名册录入类型 1：正式党员、2：入党积极分子、3：预备党员
            name: {type:Sequelize.STRING(100), allowNull:false}, //姓名
            sex: {type:Sequelize.INTEGER, allowNull:false, defaultValue:1}, //性别 1：男、2：女
            birthDate: {type:Sequelize.DATE, allowNull:false}, //出生年月
            phone: {type:Sequelize.STRING(11), allowNull:false}, //手机号码
            levelOfEducation: {type:Sequelize.INTEGER, allowNull:false}, //文化程度
            bId: {type:Sequelize.INTEGER(20), allowNull:false}, //支部表id 外键
            partyJoiningTime: {type:Sequelize.DATE, allowNull:true}, //入党时间 --正式党员录入
            administrativePositionName: {type:Sequelize.INTEGER, allowNull:true, defaultValue:1}, //行政职务id 枚举 默认1：普通职员
            partyPositionsName: {type:Sequelize.STRING(100), allowNull:true, defaultValue:'[]'}, //党内职务id 枚举 --正式党员录入  [1,2]  --多选
            departmentName: {type:Sequelize.STRING(100), allowNull:true, defaultValue:'[]'}, //所属科室表id 枚举 [1,2] --多选
            askForTime: {type:Sequelize.DATE, allowNull:true}, //申请入党时间 --入党积极分子录入、入党申请录入
            listedAsActivistsTime: {type:Sequelize.DATE, allowNull:true}, //列为积极分子时间 --入党积极分子录入
            liaison: {type:Sequelize.STRING(100), allowNull:true, defaultValue:'[]'}, //联系人 --入党积极分子录入 "" --多选
            talkTime: {type:Sequelize.DATE, allowNull:true}, //谈话时间 --入党申请录入
            partyState: {type:Sequelize.INTEGER, allowNull:true, defaultValue:1}, //党员状态 1：在党、2：退党
            isAdmin: {type:Sequelize.BOOLEAN, allowNull:true, defaultValue:false}, //是否为管理员
            /**小程序登录 */
            loginId: {type:Sequelize.STRING(11),allowNull:false}, //登录账号 默认手机号
            pwd:{type:Sequelize.STRING(100), allowNull:false}, //密码 默认手机号后6位
            token:{type:Sequelize.STRING(100), allowNull:true},
            tokenMs:{ type:Sequelize.DATE, allowNull:true },
            adminToken:{type:Sequelize.STRING(100), allowNull:true},
            adminTokenMs:{ type:Sequelize.DATE, allowNull:true },
        },
        association: [
            {type: "hasMany", check: "partyExpenses", foreignKey:"pmId"},
            {type: "hasMany", check: "rateLearning", foreignKey:"pmId"},
        ]
    },
    {
        tableNameCn:'支部制度表',
        tableName:'branchSystem', 
        schema:{
            bsId: { //自增的支部制度id
                type:Sequelize.INTEGER(20), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                autoIncrement:true, //允许自增
                unique:true //表示该列的值必须唯一
            },
            systemTitle: {type:Sequelize.STRING(500), allowNull:false}, //制度标题
            bId: {type:Sequelize.STRING(100), allowNull:false, defaultValue:'[]'}, //支部表id 外键 [1,2]  --多选
            releaseTime: {type:Sequelize.DATE, allowNull:false}, //发布时间
            isUse: {type:Sequelize.BOOLEAN, allowNull:false, defaultValue:true}, //是否使用
            fileName: {type:Sequelize.STRING(500), allowNull:true, defaultValue:'[]'}, //文件名称 ["",""] --多选
            fileType: {type:Sequelize.INTEGER, allowNull:true}, //文件类型
            uploadTime: {type:Sequelize.DATE, allowNull:true, defaultValue:Sequelize.NOW}, //上传时间
        },
        association: []
    },
    {
        tableNameCn:'组织生活表',
        tableName:'organizationalLife', 
        schema:{
            oId: { //自增的组织生活id
                type:Sequelize.INTEGER(20), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                autoIncrement:true, //允许自增
                unique:true //表示该列的值必须唯一
            },
            theme: {type:Sequelize.STRING(500), allowNull:false},//主题
            themeType: {type:Sequelize.INTEGER, allowNull:false}, //主题类型
            dataMonth: {type:Sequelize.DATE, allowNull:false}, //数据月份
            bId: {type:Sequelize.INTEGER, allowNull:false}, //支部表id 外键
            fileName: {type:Sequelize.STRING(500), allowNull:true, defaultValue:'[]'}, //文件名称 ["",""] --多选
            fileType: {type:Sequelize.INTEGER, allowNull:true}, //文件类型
            uploadTime: {type:Sequelize.DATE, allowNull:true, defaultValue:Sequelize.NOW}, //上传时间
        },
        association: []
    },
    {
        tableNameCn:'专题活动表', //党建资讯
        tableName:'thematicActivities', 
        schema:{
            taId: { //自增的专题活动id
                type:Sequelize.INTEGER(20), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                autoIncrement:true, //允许自增
                unique:true //表示该列的值必须唯一
            },
            theme: {type:Sequelize.STRING(500), allowNull:false},//主题
            dataMonth: {type:Sequelize.DATE, allowNull:false}, //数据月份
            bId: {type:Sequelize.INTEGER, allowNull:false}, //支部表id 外键
            fileName: {type:Sequelize.STRING(500), allowNull:true, defaultValue:'[]'}, //文件名称 ["",""] --多选
            fileType: {type:Sequelize.INTEGER, allowNull:true}, //文件类型
            uploadTime: {type:Sequelize.DATE, allowNull:true, defaultValue:Sequelize.NOW}, //上传时间
        },
        association: []
    },
    {
        tableNameCn:'党建动态表',
        tableName:'partyBuildingDynamic', 
        schema:{
            pbId: { //自增的党建动态id
                type:Sequelize.INTEGER(20), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                autoIncrement:true, //允许自增
                unique:true //表示该列的值必须唯一
            },
            theme: {type:Sequelize.STRING(500), allowNull:false},//活动名称
            dataMonth: {type:Sequelize.DATE, allowNull:false}, //数据月份
            bId: {type:Sequelize.INTEGER, allowNull:false}, //支部表id 外键
            fileName: {type:Sequelize.STRING(500), allowNull:true, defaultValue:'[]'}, //文件名称 ["",""] --多选
            fileType: {type:Sequelize.INTEGER, allowNull:true}, //文件类型
            uploadTime: {type:Sequelize.DATE, allowNull:true, defaultValue:Sequelize.NOW}, //上传时间
        },
        association: []
    },
    {
        tableNameCn:'党费管理表',
        tableName:'partyExpenses', 
        schema:{
            peId: { //自增的党费id
                type:Sequelize.INTEGER(20), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                autoIncrement:true, //允许自增
                unique:true //表示该列的值必须唯一
            },
            pmId: {type:Sequelize.STRING(100), allowNull:false}, //党员信息表id 外键
            bId: {type:Sequelize.INTEGER, allowNull:false}, //支部表id 外键
            payType: {type:Sequelize.INTEGER, allowNull:false, defaultValue:2}, //缴纳状态 1：已缴纳、2：未缴纳
            payableMonth: {type:Sequelize.DATE, allowNull:false}, //应交月份
            payTime: {type:Sequelize.DATE, allowNull:true}, //缴费时间
            payAmount: {type:Sequelize.INTEGER, allowNull:true}, //缴费金额（元）
        },
        association: []
    },
    {
        tableNameCn:'党建先锋表',
        tableName:'partyVanguard', 
        schema:{
            pvId: { //自增的党建先锋id
                type:Sequelize.INTEGER(20), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                autoIncrement:true, //允许自增
                unique:true //表示该列的值必须唯一
            },
            honorName: {type:Sequelize.STRING(500), allowNull:false}, //荣誉名称
            honorType: {type:Sequelize.INTEGER, allowNull:false}, //荣誉类型 枚举
            grantingRange: {type:Sequelize.INTEGER, allowNull:false}, //授予范围 枚举
            grantingUnit: {type:Sequelize.STRING(100), allowNull:false}, //授予单位/个人
            grantTime: {type:Sequelize.DATE, allowNull:false},//授予时间
            bId: {type:Sequelize.INTEGER, allowNull:false}, //支部表id
            isUse: {type:Sequelize.BOOLEAN, allowNull:false, defaultValue:true}, //是否使用
        },
        association: []
    },
    {
        tableNameCn:'党员学习表',
        tableName:'memberLearning', 
        schema:{
            mlId: { //自增的党员学习id
                type:Sequelize.INTEGER(20), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                autoIncrement:true, //允许自增
                unique:true //表示该列的值必须唯一
            },
            contentTitle: {type:Sequelize.STRING(500), allowNull:false}, //内容标题
            courseTypeName: {type:Sequelize.INTEGER, allowNull:false}, //课程类型id 枚举
            courseEntryType: {type:Sequelize.INTEGER, allowNull:false}, //课程录入类型 1：视频课程、2：文字课程
            hits: {type:Sequelize.INTEGER, allowNull:false}, //点击量
            coverImage: {type:Sequelize.STRING(500), allowNull:true, defaultValue:'defalitImage.png'}, //封面图
            videoDuration: {type:Sequelize.STRING(500), allowNull:true}, //视频时长
            isUse: {type:Sequelize.BOOLEAN, allowNull:false, defaultValue:true}, //是否使用
            fileName: {type:Sequelize.STRING(500), allowNull:true, defaultValue:'[]'}, //文件名称 ["",""] --多选
            fileType: {type:Sequelize.INTEGER, allowNull:true}, //文件类型
            uploadTime: {type:Sequelize.DATE, allowNull:true, defaultValue:Sequelize.NOW}, //上传时间
            updateTime: {type:Sequelize.DATE, allowNull:true, defaultValue:Sequelize.NOW}, //更新时间
            isDelete: {type:Sequelize.BOOLEAN, allowNull:false, defaultValue:false}, //是否删除
        },
        association: [
            {type: "hasMany", check: "rateLearning",foreignKey:"mlId"},
        ]
    },
    {
        tableNameCn:'学习进度表',
        tableName:'rateLearning', 
        schema:{
            rlId: {
                type:Sequelize.INTEGER(20), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                autoIncrement:true, //允许自增
                unique:true //表示该列的值必须唯一
            },
            pmId: {type:Sequelize.STRING(100), allowNull:false}, //党员id 外键
            mlId: {type:Sequelize.INTEGER, allowNull:false}, //党员学习id 外键
            rateOfLearning: {type:Sequelize.INTEGER, allowNull:false, defaultValue:0}, //学习进度
            learningCompleted: {type:Sequelize.INTEGER, allowNull:false, defaultValue:1}//是否已完成  1：正在进行、2：阅读完成
        },
        association: []
    },
    {
        tableNameCn:'学习强国',
        tableName:'learningPower', 
        schema:{
            lpId: { //自增的党员学习id
                type:Sequelize.INTEGER(20), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                autoIncrement:true, //允许自增
                unique:true //表示该列的值必须唯一
            },
            pmId: {type:Sequelize.STRING(100), allowNull:false}, //党员id
            partyMemberName: {type:Sequelize.STRING(100), allowNull:false}, //党员姓名
            bId: {type:Sequelize.INTEGER, allowNull:false}, //支部表id 外键
            dayIntegral: {type:Sequelize.INTEGER, allowNull:false}, //当日积分 
            totalIntegral: {type:Sequelize.INTEGER, allowNull:false},//总积分
            dataTime: {type:Sequelize.DATE, allowNull:false}, //数据时间
            fileName: {type:Sequelize.STRING(500), allowNull:true, defaultValue:'[]'}, //文件名称 ["",""] --多选
            fileType: {type:Sequelize.INTEGER, allowNull:true}, //文件类型
            uploadTime: {type:Sequelize.DATE, allowNull:true, defaultValue:Sequelize.NOW}, //上传时间
        },
        association: []
    },
    {
        tableNameCn:'党建质量',
        tableName:'partyQuality', 
        schema:{
            pqId: { //自增的党建质量id
                type:Sequelize.INTEGER(20), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                autoIncrement:true, //允许自增
                unique:true //表示该列的值必须唯一
            },
            bId: {type:Sequelize.INTEGER, allowNull:false}, //支部表id 外键
            primaryIndicators: {type:Sequelize.INTEGER, allowNull:false}, //一级指标 枚举
            secondaryIndicators: {type:Sequelize.STRING(500), allowNull:false}, //二级指标 枚举
            thirdLevelScore: {type:Sequelize.INTEGER, allowNull:false, defaultValue:0}, //三级指标分值
            thirdLevelContent: {type:Sequelize.STRING(500), allowNull:false, defaultValue:''}, //三级指标内容
            currentScore: {type:Sequelize.INTEGER, allowNull:false, defaultValue:0}, //当前得分
            completionProgress: {type:Sequelize.INTEGER, allowNull:false}, //完成进度
            weight: {type:Sequelize.INTEGER, allowNull:false} //权重
        },
        association: []
    },
]; 