import { ERRORENUM } from "../../config/errorEnum";
import { modelMap } from "../../model/modelBind";
import { BizError } from "../../util/bizError";


/**
 * 添加数据
 * @param tableName 表名
 * @param data 
 * @returns 
 */
export async function addData(tableName:string, data:any) {
    let model = modelMap[tableName];
    if (!model) throw new BizError(ERRORENUM.不存在表);

    if ( Array.isArray(data) ) {
        await model.addData(data);
    } else {
        /**单个 */
        await model.addData(data);
    }

    return {isSuccess:true};
}