/**
 * 表统一管理
 */


export const TablesConfig = {
    "党员基础信息表":{
        tableName:'partyMember', 
        schema:{
            id: {type:Number, index:{unique:true}}, //自增的id
            entryType: Number, //名册录入类型
            name: String, //姓名
            sex: Number, //性别
            birthDate: {type:Number, index:true}, //出生年月
            phone: String, //手机号码
            levelOfEducation: Number, //文化程度
            branchName: {type:[Number], default:[]}, //所属支部
            partyJoiningTime: {type:Number, index:true}, //入党时间 --正式党员录入
            administrativePosition: {type:Number, default:1}, //行政职务 默认普通职员
            partyPositions: {type:[Number], default:[]}, //党内职务 多选 --正式党员录入
            department: {type:[Number], default:[]}, //所属科室
            askForTime: {type:Number, index:true}, //申请入党时间 --入党积极分子录入、入党申请录入
            listedAsActivistsTime: {type:Number, index:true}, //列为积极分子时间 --入党积极分子录入
            liaison: {type:[String], default:[]}, //联系人 --入党积极分子录入
            talkTime: {type:Number, index:true}, //谈话时间 --入党申请录入
            partyState: Number, //党员状态
            learning: {type:[String], default:[]}, //学习课程
            /**-----用户相关----- */
            loginId: {type: String, index: true}, //登录账号 默认手机号
            pwd: String, //密码 默认手机号后6位
            token:{type:String, index:true},
            tokenMs:Number,
            firstLoginIsChangePwd:{type:Boolean, default:false}, //首次登录是否修改密码
        }
    },
    "支部制度表":{
        tableName:'branchSystem', 
        schema:{
            bId: {type:Number, index:{unique:true}}, //自增的支部制度id
            systemTitle: String, //制度标题
            periodOfValidity: Number, //制度有效范围
            branchName: {type:[Number], default:[]}, //所属支部
            releaseTime: {type:Number, index:true}, //发布时间
            isUse: Boolean, //是否使用
            fileName: {type:String, default:[]}, //文件名称
            fileType: String, //文件类型
            uploadTime: {type:Number, index:true}, //上传时间
        }
    },
    "组织生活表":{
        tableName:'organizationalLife', 
        schema:{
            oId: {type:Number, index:{unique:true}}, //自增的组织生活id
            theme: String,//主题
            themeType: Number, //主题类型
            dataMonth: {type:Number, index:true}, //数据月份
            branchName: {type:[Number], default:[]}, //所属支部
            fileName: {type:String, default:[]}, //文件名称
            fileType: String, //文件类型
            uploadTime: {type:Number, index:true}, //上传时间
        }
    },
    "专题活动表":{
        tableName:'thematicActivities', 
        schema:{
            tId: {type:Number, index:{unique:true}}, //自增的专题活动id
            theme: String,//主题
            dataMonth: {type:Number, index:true}, //数据月份
            branchName: {type:[Number], default:[]}, //所属支部
            fileName: {type:String, default:[]}, //文件名称
            fileType: String, //文件类型
            uploadTime: {type:Number, index:true}, //上传时间
        }
    },
    "党建动态表":{
        tableName:'partyBuildingDynamic', 
        schema:{
            pbId: {type:Number, index:{unique:true}}, //自增的党建动态id
            theme: String,//主题
            dataMonth: {type:Number, index:true}, //数据月份
            branchName: {type:[Number], default:[]}, //所属支部
            fileName: {type:String, default:[]}, //文件名称
            fileType: String, //文件类型
            uploadTime: {type:Number, index:true}, //上传时间
        }
    },
    "党费管理表":{
        tableName:'partyExpenses', 
        schema:{
            peId: {type:Number, index:{unique:true}}, //自增的党费id
            partyMember: String, //党员姓名
            payType: Number, //缴纳状态
            payableMonth: {type:Number, index:true}, //应交月份
            branchName: {type:[Number], default:[]}, //所属支部
            payTime: {type:Number, index:true}, //缴费时间
            payAmount: Number, //缴费金额（元）
        }
    },
    "党建先锋表":{
        tableName:'partyVanguard', 
        schema:{
            pvId: {type:Number, index:{unique:true}}, //自增的党建先锋id
            honorName: String, //荣誉名称
            honorType: Number, //荣誉类型
            grantingRange:String, //授予范围
            grantingUnit:String, //授予单位/个人
            grantTime: {type:Number, index:true},//授予时间
            branchName: {type:[Number], default:[]}, //所属支部
            isUse: Boolean, //是否使用
            primaryIndicators: Number, //一级指标
            secondaryIndicators: String,//二级指标
            IndicatorContent: String, //指标内容
            evaluatingIndicator: Number, //指标评分
            currentScore: {type:Number, default:0},//当前得分
            completionProgress: String //完成进度
        }
    },
    "党员学习表":{
        tableName:'memberLearning', 
        schema:{
            mlId: {type:Number, index:{unique:true}}, //自增的党员学习id
            contentTitle: String, //内容标题
            courseType: Number, //课程类型
            courseEntryType: Number, //课程录入类型
            hits: Number, //点击量
            learningType: Number, //学习类型
            isUse: Boolean, //是否使用
            fileName: {type:String, default:[]}, //文件名称
            fileType: String, //文件类型
            uploadTime: {type:Number, index:true}, //上传时间
            /**学习强国字段 */
            name: String, //姓名
            branchName: {type:[Number], default:[]}, //所属支部
            monthIntegral: Number, //本月积分
            totalIntegral: Number,//总积分
        }
    },
}

export let EccTableConfig = {};


function initEccTableConfig() {
    for(let tableChName in TablesConfig) {
        let {tableName, schema} = TablesConfig[tableChName];
        EccTableConfig[tableName] ={};
        

        for (let filesName in schema) {
            let valueType = typeof schema[filesName];
            let value = schema[filesName];
            EccTableConfig[tableName][filesName] = {type:'', notMustHave:false};
            if (valueType == "function") {
                EccTableConfig[tableName][filesName].type = value.name;
            } else if (valueType == "object") {
                if (!value.type) {
                    EccTableConfig[tableName][filesName].type = `[${value[0].name}]`;
                   
                } else {
                    if (typeof value.type == "function") {
                        EccTableConfig[tableName][filesName].type = value.type.name
                    } else EccTableConfig[tableName][filesName].type = `[${value.type[0].name}]`;
                    if (value.index) EccTableConfig[tableName][filesName].notMustHave = true;
                }
            }
        }
        
    }
    console.log('table eccConfig init success');
}

initEccTableConfig();