/**
 * 用于模型层绑定方法
 */

import { TablesConfig } from "../config/mongoTableConfig";
import {Schema} from 'mongoose';
import { baseDB } from "../db/mongo/dbInit";


let modelMap = {}
export async function initModel() {
    /**初始化表 */
    for (let key in TablesConfig) {
        let {tableName, schema} = TablesConfig[key];
        modelMap[tableName] = baseDB.model(tableName, new Schema(schema) );
        
        modelMap[tableName].addData = addManyDataBind;
        modelMap[tableName].updateOnceData = updateOnceDataBind;
        modelMap[tableName].updateManyData = updateManyDataBind;
        modelMap[tableName].deleteOneData = deleteOneBind;

        modelMap[tableName].findOnceData = findOnceDataBind;
        modelMap[tableName].findManyData = findManyDataBind;
        modelMap[tableName].findDataCount = findDataCountBind;
        modelMap[tableName].findDataToPage = findDataToPageBind;
        modelMap[tableName].aggragateData = aggragateDataBind;
        
    }
}


async function addManyDataBind(dataList) {
    return await this.insertMany(dataList, {ordered:false, bypassDocumentValidation:true});
}


async function updateOnceDataBind(param, updateInfo) {
    return await this.update(param, {"$set":updateInfo});
}


async function updateManyDataBind(param, updateInfo) {
    return await this.updateMany(param, {"$set":updateInfo});
}


async function deleteOneBind(param) {
    return await this.deleteOne(param);
}


async function findOnceDataBind(column, param) {
    return await this.findOne({attribute:column, where:param});
}


async function findManyDataBind(column, param) {
    return await this.find({attribute:column, where:param});
}


async function findDataCountBind(param) {
    return await this.find(param).count();
}


async function findDataToPageBind(column, param, skipCount:number, limit:number) {
    return await this.find({attribute:column, where:param}).skip(skipCount).limit(limit);
}


async function aggragateDataBind(param) {
    return await this.aggregate(param);
}


export {modelMap};