import { ERRORENUM } from "../config/errorEnum";
import { systemConfig } from "../config/serverConfig";
import { EccTableConfig } from "../config/mongoTableConfig";
import { BizError } from "../util/bizError";
import { mysqlModelMap } from "../model/sqlModelBind";

/**
 * 中间件 校验连接对象token
 * @param req 
 * @param res 
 * @param next 
 * @returns 
 */
export async function checkMongoSign(req, res, next) {
    if (!req.headers) req.headers = {};

    let sign = req.headers.sign;
    let table = req.headers.table;

    if (sign != systemConfig.sign) return next( new BizError(ERRORENUM.身份验证失败, `传入的sign值为:${sign}`) );
    if (!table) return next( new BizError(ERRORENUM.缺少必要参数_表名, `传入的table值为:${table}`) );
    
    if (!EccTableConfig[table]) return next( new BizError(ERRORENUM.不存在表, `传入的table值为:${table}`) );
    next();
}


/**
 * 中间件 校验连接对象token
 * @param req 
 * @param res 
 * @param next 
 * @returns 
 */
export async function checkMySqlSign(req, res, next) {
    if (!req.headers) req.headers = {};

    let sign = req.headers.sign;
    let table = req.headers.table;

    if (sign != systemConfig.sign) return next( new BizError(ERRORENUM.身份验证失败, `传入的sign值为:${sign}`) );
    if (!table) return next( new BizError(ERRORENUM.缺少必要参数_表名, `传入的table值为:${table}`) );
    
    if (!mysqlModelMap[table]) return next( new BizError(ERRORENUM.不存在表, `传入的table值为:${table}`) );
    req.tableModel = mysqlModelMap[table];

    next();
}