import { ERRORENUM } from "../../config/errorEnum";
import { modelMap } from "../../model/modelBind";
import { BizError } from "../../util/bizError";

/**
 * 修改单个数据
 * @param tableName 表名
 * @param data 
 * @returns 
 */
export async function updateOneData(tableName:string, param:any, data:any) {
    let model = modelMap[tableName];
    if (!model) throw new BizError(ERRORENUM.不存在表);

    await model.updateOnceDataBind(param, data);

    return {isSuccess:true};
}


/**
 * 批量修改数据
 * @param tableName 表名
 * @param data 
 * @returns 
 */
export async function updateManyData(tableName:string, param:any, data:any) {
    let model = modelMap[tableName];
    if (!model) throw new BizError(ERRORENUM.不存在表);

    await model.updateManyData(param, data);

    return {isSuccess:true};
}