import express = require('express');
import bodyParser = require('body-parser');
import routers = require('../routers/router');
import compression = require('compression');
import { watch } from '../middleware/watch';
import { httpErrorHandler } from '../middleware/httpErrorHandler';
export class httpServer {
    static createServer(port:number) {
        var httpServer = express();

        httpServer.all('*', (req, res, next) => {
            res.header('Access-Control-Allow-Origin', req.headers.origin);
            res.header("Access-Control-Allow-Headers", "X-Requested-With");
            res.header('Access-Control-Allow-Headers', 'Content-Type,request-origin,userid,token');
            res.header("Access-Control-Allow-Methods", "PUT,POST,GET,DELETE,OPTIONS");
            res.header('Access-Control-Allow-Credentials', true);
            res.header("X-Powered-By", ' 3.2.1');
            next();
        });

        
        httpServer.use(compression());
        httpServer.use(watch);
        httpServer.use(bodyParser.json({limit:"5000kb"}));
        routers.setRouter(httpServer);
        httpServer.use(httpErrorHandler);

        httpServer.listen(port);
        console.log('server listen on port:'+port);
    }
}