import { ERRORENUM } from "../../config/errorEnum";
import { modelMap } from "../../model/modelBind";
import { BizError } from "../../util/bizError";


/**
 * 查询单个数据
 * @param tableName 表名
 * @param param 
 * @returns 
 */
export async function selectOneDataByParam(tableName:string, param:any) {
    let model = modelMap[tableName];
    if (!model) throw new BizError(ERRORENUM.不存在表);

    let data = model.findOnceData(param);
    return {data};
}

export async function selectDataListByParam(tableName:string, param:any) {
    let model = modelMap[tableName];
    if (!model) throw new BizError(ERRORENUM.不存在表);

    let data = model.findManyData(param);
    return {data};
}

export async function selectDataListToPageByParam(tableName:string, param:any, pageNumber:number, pageSize:number) {
    pageSize = pageSize || 10;
    let model = modelMap[tableName];
    if (!model) throw new BizError(ERRORENUM.不存在表);
    
    let data = model.findDataToPage(param, (pageNumber-1)*10, pageSize );
    return {data};
}

export async function selectDataCountByParam(tableName:string, param:any) {
    let model = modelMap[tableName];
    if (!model) throw new BizError(ERRORENUM.不存在表);

    let data = model.findDataCount(param);
    return {data};
}


export async function aggragateParam(tableName:string, param:any) {
    let model = modelMap[tableName];
    if (!model) throw new BizError(ERRORENUM.不存在表);

    let data = await model.aggragateData(param);

    return {data};
}