import moment = require("moment");

const md5 = require("md5");

export function getUserToken(loginId:string) {
    return md5(`${loginId}_${Math.ceil(Math.random()*1000)}${new Date().valueOf()}`);
}

export function getMySqlMs(time?) {
    time = time || new Date().valueOf();
    return moment(time).format("YYYY-MM-DD HH:mm:ss");
}

export function getClientMs(time) {
    if (!time) return new Date().valueOf();
    return new Date(time).valueOf();
}

export function getPartyMemberId(param) {
    return md5(`${param}-${new Date().valueOf()}-${Math.ceil(Math.random() * 10000)}`);
}

export function getDefPwd(phone:string) {
    return md5(`${phone.slice(5, 11)}`);
}