import { ERRORENUM } from "../config/enum/errorEnum";
import { BizError } from "../util/bizError";

/**
 * 校验value是否符合传入的枚举
 * @param name 被掉用名称 用于输出异常日志
 * @param key 目标字段  用于输出异常日志
 * @param enumConf 目标枚举
 * @param value 目标值
 * 无返回 有异常直接报错
 */
export function eccEnumValue(name:string, key:string, enumConf, value:any) {
    let eccSuccess = true;
    if ( typeof value == 'number' ) {
        if (!enumConf[value] ) eccSuccess = false;
    } else if (Array.isArray(value)) {
        value.forEach(item => {
            if ( !enumConf[item] ) eccSuccess = false;
        });
    }
    
    if (!eccSuccess) throw new BizError(ERRORENUM.请完善信息, `${name} 下的 ${key} 字段值为 ${value} 不满足枚举范围`);
}



/**
 * 将枚举值转换成对应的枚举名(key)
 * @param enumConf 目标枚举
 * @param value 目标值
 * @returns string  返回字符串 如果传入多个枚举值，就拼接字符串
 */
export function changeEnumValue(enumConf, value:any) {
    if (!value) return '';
    if ( typeof value == 'number' ) {
        let str = enumConf[value];
        return str
    } else if (typeof value == 'string') { 
        try {
            value = JSON.parse(value);
        }catch(err) {
            return enumConf[parseInt(value)];
        } 
    }
    let str = "";
    value.forEach((item, index) => {
        let subStr = enumConf[item];
        
        str += subStr;
        if (index == value.length-1) str+="";
        else str += ","
    });

    return str;
}