/***
 * 用户路由
 */

import * as asyncHandler from 'express-async-handler'
import { eccReqParamater } from '../tools/eccParam';
import * as userBIz from '../biz/user';
import { checkToken } from '../middleware/user';

export function setRouter(httpServer) {
    httpServer.post('/yfs/admin/user/login',  asyncHandler(login));
    httpServer.post('/yfs/admin/user/logout', checkToken, asyncHandler(logout));
}

async function login(req, res) {
    let reqConf = {loginId:'String', pwd:'String'};
    let {loginId, pwd} = eccReqParamater(reqConf, req.body);

    let userInfo = await userBIz.loginAdminSys(loginId, pwd);
    res.success(userInfo);
}


async function logout(req, res) {
    let userInfo = req.userInfo;

    let result = await userBIz.logout(userInfo.userId, userInfo.isSuperAdmin);
    res.success(result);
}

