

import * as asyncHandler from 'express-async-handler'
import * as enumConfig from '../config/enum/enum';

let publicRouterConfig = {
    "entrytype":enumConfig.ENTRYTYPE,//名册录入类型
    "sex":enumConfig.SEX,//性别
    "degree":enumConfig.DEGREE,//文化程度
    "branchname":enumConfig.BRANCHNAME,//支部名称
    "administrativeposition":enumConfig.ADMINISTRATIVEPOSITION,//行政职务
    "partypositions":enumConfig.PARTYPOSITIONS,//党内职务 
    "dedpartment":enumConfig.DEDPARTMENT,//所属科室
}

export function setRouter(httpServer) {
    
    for (let key in publicRouterConfig) {
        let url = `/yfs/admin/public/${key}`;
        let enumItem = publicRouterConfig[key];
        httpServer.post(url,  asyncHandler((req, res) => {
            let dataList = [];
            for (let key in enumItem) {
                let anyKey:any = key;
                if (isNaN(anyKey)) {
                    let keyStr = key;
                    dataList.push({key:keyStr, value:enumItem[key]});
                }
            }
            res.success({dataList});
        }));
    }
}
