/***
 * 党员路由
 */

import * as asyncHandler from 'express-async-handler'
import { eccReqParamater } from '../tools/eccParam';
import * as partyMemberBiz from '../biz/partyMember';
import { checkToken } from '../middleware/user';

export function setRouter(httpServer) {
    
    httpServer.post('/yfs/admin/partymember/del', checkToken, asyncHandler(delMember));
    httpServer.post('/yfs/admin/partymember/formal/list', checkToken, asyncHandler(formalPartyList));
    httpServer.post('/yfs/admin/partymember/formal/info', checkToken, asyncHandler(formalPartyInfo));
    httpServer.post('/yfs/admin/partymember/formal/update', checkToken, asyncHandler(updateFormalPartyInfo));
    httpServer.post('/yfs/admin/partymember/formal/create', checkToken, asyncHandler(createFormalPartyInfo));
    httpServer.post('/yfs/admin/partymember/formal/admin/open', checkToken, asyncHandler(openAdminState));
    httpServer.post('/yfs/admin/partymember/formal/admin/close', checkToken, asyncHandler(closeAdminState));
    

    httpServer.post('/yfs/admin/partymember/activists/list', checkToken, asyncHandler(activistsPartyList));
    httpServer.post('/yfs/admin/partymember/activists/info', checkToken, asyncHandler(activistsPartyInfo));
    httpServer.post('/yfs/admin/partymember/activists/update', checkToken, asyncHandler(updateActivistsInfo));
    httpServer.post('/yfs/admin/partymember/activists/create', checkToken, asyncHandler(createActivistsInfo));

    httpServer.post('/yfs/admin/partymember/candidate/list', checkToken, asyncHandler(candidatePartyList));
    httpServer.post('/yfs/admin/partymember/candidate/info', checkToken, asyncHandler(candidatePartyInfo));
    httpServer.post('/yfs/admin/partymember/candidate/update', checkToken, asyncHandler(updateCandidateInfo));
    httpServer.post('/yfs/admin/partymember/candidate/create', checkToken, asyncHandler(createCandidateInfo));
   
}

/**
 * 正式党员列表
 * @param req 
 * @param res 
 */
async function formalPartyList(req, res) {
    let userInfo = req.userInfo;

    let reqConf = {branch:'Number', name:'String', pageNumber:'Number'};
    let {branch, name, pageNumber} = eccReqParamater(reqConf, req.body, ["branch", "name"]);

    let result = await partyMemberBiz.formalList(branch, name, pageNumber);

    res.success(result);
}

/**
 * 回显正式党员信息
 * @param req 
 * @param res 
 */
async function formalPartyInfo(req, res) {
    let userInfo = req.userInfo;

    let reqConf = {pmId:'String'};
    let {pmId} = eccReqParamater(reqConf, req.body);

    let result  = await partyMemberBiz.partyFormalMemberInfomation(pmId);

    res.success(result);
}

/**
 * 修改正式党员信息
 * @param req 
 * @param res 
 */
async function updateFormalPartyInfo(req, res) {
    let userInfo = req.userInfo;

    let reqConf = {pmId:'String', form:'Object'};
    let { pmId, form } = eccReqParamater(reqConf, req.body);

    let result = await partyMemberBiz.updatePartyFormalMemberData(pmId, form);
    res.success(result);
}


async function createFormalPartyInfo(req, res) {
    let userInfo = req.userInfo;

    let reqConf = {form:'Object'};
    let {form } = eccReqParamater(reqConf, req.body);

    let result = await partyMemberBiz.createFormalMember(userInfo, form);
    res.success(result);
}




/**
 * 积极分子列表
 * @param req 
 * @param res 
 */
async function activistsPartyList(req, res) {
    let userInfo = req.userInfo;

    let reqConf = {branch:'Number', name:'String', pageNumber:'Number'};
    let {branch, name, pageNumber} = eccReqParamater(reqConf, req.body, ["branch", "name"]);

    let result = await partyMemberBiz.activistsList(branch, name, pageNumber);

    res.success(result);
}


/**
 * 回显积极分子信息
 * @param req 
 * @param res 
 */
async function activistsPartyInfo(req, res) {
    let userInfo = req.userInfo;

    let reqConf = {pmId:'String'};
    let {pmId} = eccReqParamater(reqConf, req.body);

    let result = await partyMemberBiz.partyActivistsMemberInfomation(pmId);
    res.success(result);
}

async function updateActivistsInfo(req, res) {
    let userInfo = req.userInfo;

    let reqConf = {pmId:'String', form:'Object'};
    let { pmId, form } = eccReqParamater(reqConf, req.body);

    let result = await partyMemberBiz.updatePartyActivistsMemberData(pmId, form);
    res.success(result);
}

async function createActivistsInfo(req, res) {
    let userInfo = req.userInfo;

    let reqConf = { form:'Object'};
    let { form } = eccReqParamater(reqConf, req.body);

    let result = await partyMemberBiz.createActivistsMember(userInfo, form);
    res.success(result);
}



/**
 * 预备党员列表
 * @param req 
 * @param res 
 */
async function candidatePartyList(req, res) {
    let userInfo = req.userInfo;

    let reqConf = {branch:'Number', name:'String', pageNumber:'Number'};
    let {branch, name, pageNumber} = eccReqParamater(reqConf, req.body, ["branch", "name"]);

    let result = await partyMemberBiz.candidateList(branch, name, pageNumber);

    res.success(result);
}

async function candidatePartyInfo(req, res) {
    let userInfo = req.userInfo;

    let reqConf = {pmId:'String'};
    let {pmId} = eccReqParamater(reqConf, req.body);

    let result = await partyMemberBiz.partyCandidateMemberInfomation(pmId);
    res.success(result);
}


/**
 * 修改预备党员信息
 * @param req 
 * @param res 
 */
async function updateCandidateInfo(req, res) {
    let userInfo = req.userInfo;

    let reqConf = {pmId:'String', form:'Object'};
    let { pmId, form } = eccReqParamater(reqConf, req.body);

    let result = await partyMemberBiz.updatePartyCandidateMemberData(pmId, form);
    res.success(result);
}


async function createCandidateInfo(req, res) {
    let userInfo = req.userInfo;

    let reqConf = {form:'Object'};
    let { form } = eccReqParamater(reqConf, req.body);

    let result = await partyMemberBiz.createCandidateMember(userInfo, form);
    res.success(result);
}

async function openAdminState(req, res) {
    let userInfo = req.userInfo;

    let reqConf = {pmId:'String'};
    let { pmId } = eccReqParamater(reqConf, req.body);

    let result = await partyMemberBiz.openformalAdminState(userInfo, pmId);
    res.success(result);
}


async function closeAdminState(req, res) {
    let userInfo = req.userInfo;

    let reqConf = {pmId:'String'};
    let { pmId } = eccReqParamater(reqConf, req.body);

    let result = await partyMemberBiz.closeformalAdminState(userInfo, pmId);
    res.success(result);
}

async function delMember(req, res) {
    let userInfo = req.userInfo;

    let reqConf = {pmId:'String'};
    let { pmId } = eccReqParamater(reqConf, req.body);

    let result = await partyMemberBiz.deleteMember(userInfo, pmId);
    res.success(result);
}