import * as asyncHandler from 'express-async-handler';
import * as organizationBiz from '../biz/organization';
import { checkToken } from '../middleware/user';

export function setRouter(httpServer) {
    httpServer.post('/yfs/admin/organization/list', checkToken, asyncHandler(organizationInfo));
}


/**
 * 组织架构
 * @param req 
 * @param res 
 */
async function organizationInfo(req, res) {
    let userInfo = req.userInfo;

    let result = await organizationBiz.getOrganization();

    res.success(result);
}

